/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.world.ITotem;
import java.util.List;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampirismVillageEvent
extends Event {
    protected final ITotem totem;

    public VampirismVillageEvent(ITotem totem) {
        this.totem = totem;
    }

    @Nullable
    public IFaction<?> getCapturingFaction() {
        return this.totem.getCapturingFaction();
    }

    @Nullable
    public IFaction<?> getControllingFaction() {
        return this.totem.getControllingFaction();
    }

    public ITotem getTotem() {
        return this.totem;
    }

    @NotNull
    public AABB getVillageArea() {
        return this.totem.getVillageArea();
    }

    @NotNull
    public AABB getVillageAreaReduced() {
        return this.totem.getVillageAreaReduced();
    }

    public Level getWorld() {
        return this.totem.getTileWorld();
    }

    public static class DefineRaidStrength
    extends VampirismVillageEvent {
        private final int badOmenLevel;
        private float defendStrength;
        private float attackStrength;

        public DefineRaidStrength(ITotem totem, int badOmenLevel, float defendStrength, float attackStrength) {
            super(totem);
            this.badOmenLevel = badOmenLevel;
            this.defendStrength = defendStrength;
            this.attackStrength = attackStrength;
        }

        public float getAttackStrength() {
            return this.attackStrength;
        }

        public void setAttackStrength(float attackStrength) {
            this.attackStrength = attackStrength;
        }

        public int getBadOmenLevel() {
            return this.badOmenLevel;
        }

        public float getDefendStrength() {
            return this.defendStrength;
        }

        public void setDefendStrength(float defendStrength) {
            this.defendStrength = defendStrength;
        }

        public boolean isBadOmenTriggered() {
            return this.badOmenLevel >= 0;
        }

        public boolean isPlayerRaid() {
            return this.badOmenLevel == -2;
        }

        public boolean isRandomRaid() {
            return this.badOmenLevel == -1;
        }
    }

    public static class InitiateCapture
    extends VampirismVillageEvent {
        @NotNull
        private final IFaction<?> capturingFaction;
        @Nullable
        private String message;
        private boolean disallowCapture = false;

        public InitiateCapture(ITotem totem, @NotNull IFaction<?> capturingFaction) {
            super(totem);
            this.capturingFaction = capturingFaction;
        }

        @Override
        @NotNull
        public IFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }

        @Nullable
        public String getMessage() {
            return this.message;
        }

        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        public void disallowCapture() {
            this.disallowCapture = true;
        }

        public boolean isCaptureDisallowed() {
            return this.disallowCapture;
        }
    }

    public static abstract class VillagerCaptureFinish
    extends VampirismVillageEvent {
        @NotNull
        private final List<Villager> villager;
        private final boolean forced;

        public VillagerCaptureFinish(ITotem totem, @NotNull List<Villager> villagerIn, boolean forced) {
            super(totem);
            this.villager = villagerIn;
            this.forced = forced;
        }

        @NotNull
        public List<Villager> getVillager() {
            return this.villager;
        }

        public boolean isForced() {
            return this.forced;
        }

        public static class Pre
        extends VillagerCaptureFinish {
            private boolean disableEntityConversion = false;

            public Pre(ITotem totem, @NotNull List<Villager> villagerIn, boolean forced) {
                super(totem, villagerIn, forced);
            }

            public void setDisableEntityConversion(boolean disableEntityConversion) {
                this.disableEntityConversion = disableEntityConversion;
            }

            public boolean isEntityConversionDisabled() {
                return this.disableEntityConversion;
            }
        }

        public static class Post
        extends VillagerCaptureFinish {
            public Post(ITotem totem, @NotNull List<Villager> villagerIn, boolean forced) {
                super(totem, villagerIn, forced);
            }
        }
    }

    public static class MakeAggressive
    extends VampirismVillageEvent
    implements ICancellableEvent {
        @NotNull
        private final Villager oldVillager;

        public MakeAggressive(ITotem totem, @NotNull Villager villager) {
            super(totem);
            this.oldVillager = villager;
        }

        public Villager getOldVillager() {
            return this.oldVillager;
        }
    }

    public static class SpawnNewVillager
    extends VampirismVillageEvent {
        @Nullable
        private final Mob oldEntity;
        private final boolean replace;
        @NotNull
        private Villager newVillager;

        public SpawnNewVillager(ITotem totem, @Nullable Mob oldEntity, @NotNull Villager newVillager, boolean replace) {
            super(totem);
            this.oldEntity = oldEntity;
            this.newVillager = newVillager;
            this.replace = replace;
        }

        @Nullable
        public IFaction<?> getFaction() {
            return this.totem.getControllingFaction();
        }

        @NotNull
        public Villager getNewVillager() {
            return this.newVillager;
        }

        public void setNewVillager(@NotNull Villager newVillager) {
            this.newVillager = newVillager;
        }

        @Nullable
        public Mob getOldEntity() {
            return this.oldEntity;
        }

        public boolean isReplace() {
            return this.replace;
        }
    }
}

