/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.FluidTankWithListener;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.general.IBloodConversionRegistry;
import de.teamlapen.vampirism.blocks.SieveBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class SieveBlockEntity
extends BlockEntity
implements FluidTankWithListener.IFluidTankListener {
    @NotNull
    private final FluidTankWithListener tank = new FilteringFluidTank(2000).setListener(this);
    private int cooldownPull = 0;
    private int cooldownProcess = 0;
    private boolean active;

    public SieveBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.SIEVE.get(), pos, state);
        this.tank.setDrainable(false);
    }

    @NotNull
    public FluidTankWithListener getTank() {
        return this.tank;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("active", this.isActive());
        return nbt;
    }

    public boolean isActive() {
        return this.active;
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.tank.readFromNBT(provider, tag);
        this.cooldownProcess = tag.getInt("cooldown_process");
        this.cooldownPull = tag.getInt("cooldown_pull");
    }

    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        CompoundTag tag = pkt.getTag();
        boolean old = this.active;
        this.active = tag.getBoolean("active");
        if (this.active != old && this.level != null) {
            this.requestModelDataUpdate();
            this.level.sendBlockUpdated(this.getBlockPos(), this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
        }
    }

    @Override
    public void onTankContentChanged() {
        this.setActive(!this.tank.isEmpty(), this.getBlockState());
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        this.tank.writeToNBT(provider, compound);
        compound.putInt("cooldown_process", this.cooldownProcess);
        compound.putInt("cooldown_pull", this.cooldownPull);
    }

    public static void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull SieveBlockEntity blockEntity) {
        if (--blockEntity.cooldownProcess < 0) {
            blockEntity.cooldownProcess = 15;
            if (blockEntity.tank.getFluidAmount() > 0) {
                FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.below(), (Direction)Direction.UP).ifPresent(handler -> {
                    blockEntity.tank.setDrainable(true);
                    FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)blockEntity.tank, (int)200, (boolean)true);
                    blockEntity.tank.setDrainable(false);
                    if (!transferred.isEmpty()) {
                        blockEntity.cooldownProcess = 30;
                        blockEntity.setActive(true, state);
                    }
                });
            } else if (blockEntity.active) {
                blockEntity.setActive(false, state);
            }
        }
        if (--blockEntity.cooldownPull < 0) {
            blockEntity.cooldownPull = 10;
            FluidUtil.getFluidHandler((Level)level, (BlockPos)pos.above(), (Direction)Direction.DOWN).ifPresent(handler -> {
                FluidStack transferred = FluidUtil.tryFluidTransfer((IFluidHandler)blockEntity.tank, (IFluidHandler)handler, (int)200, (boolean)true);
            });
        }
    }

    private void setActive(boolean active, @NotNull BlockState blockState) {
        if (this.active != active) {
            this.active = active;
            if (this.level != null && blockState.getBlock() == ModBlocks.BLOOD_SIEVE.get()) {
                this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue((Property)SieveBlock.PROPERTY_ACTIVE, (Comparable)Boolean.valueOf(active)));
            }
        }
    }

    private class FilteringFluidTank
    extends FluidTankWithListener {
        private FilteringFluidTank(int capacity) {
            super(capacity);
        }

        @Override
        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            IBloodConversionRegistry registry = VampirismAPI.bloodConversionRegistry();
            if (!registry.hasConversion(resource.getFluid())) {
                return 0;
            }
            FluidStack converted = registry.getBloodFromFluid(resource);
            int filled = super.fill(converted, action);
            if (action.execute()) {
                SieveBlockEntity.this.cooldownPull = 10;
            }
            return (int)((float)filled / registry.getFluidConversion(resource.getFluid()).conversionRate());
        }
    }
}

