/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.VampireBeaconMenu;
import de.teamlapen.vampirism.mixin.accessor.BeaconBeamSectionyMixin;
import de.teamlapen.vampirism.util.Helper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VampireBeaconBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private static final int MAX_LEVELS = 3;
    public static final Holder<MobEffect>[][] BEACON_EFFECTS = new Holder[][]{{MobEffects.MOVEMENT_SPEED, MobEffects.SATURATION}, {MobEffects.NIGHT_VISION, MobEffects.WATER_BREATHING}, {MobEffects.REGENERATION}};
    public static final int[][] BEACON_EFFECTS_AMPLIFIER = new int[][]{{0, 0}, {0, 0}, {0, 1}};
    public static final Set<Holder<MobEffect>> NO_AMPLIFIER_EFFECTS = Set.of(MobEffects.NIGHT_VISION, MobEffects.WATER_BREATHING);
    private static final Set<Holder<MobEffect>> VALID_EFFECTS = Arrays.stream(BEACON_EFFECTS).flatMap(Arrays::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_AMPLIFIER = 2;
    public static final int DATA_UPGRADED = 3;
    public static final int NUM_DATA_VALUES = 4;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final Component DEFAULT_NAME = Component.translatable((String)"container.beacon");
    private List<BeaconBlockEntity.BeaconBeamSection> beamSections = Lists.newArrayList();
    private List<BeaconBlockEntity.BeaconBeamSection> checkingBeamSections = Lists.newArrayList();
    private int levels;
    private int lastCheckY;
    @Nullable
    private Holder<MobEffect> primaryPower;
    private int effectAmplifier;
    private boolean isUpgraded;
    @Nullable
    private Component name;
    private LockCode lockKey = LockCode.NO_LOCK;
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int slot) {
            return switch (slot) {
                case 0 -> VampireBeaconBlockEntity.this.levels;
                case 1 -> BeaconMenu.encodeEffect(VampireBeaconBlockEntity.this.primaryPower);
                case 2 -> VampireBeaconBlockEntity.this.effectAmplifier;
                case 3 -> {
                    if (VampireBeaconBlockEntity.this.isUpgraded) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int slot, int value) {
            switch (slot) {
                case 0: {
                    VampireBeaconBlockEntity.this.levels = value;
                    break;
                }
                case 1: {
                    if (!((VampireBeaconBlockEntity)VampireBeaconBlockEntity.this).level.isClientSide && !VampireBeaconBlockEntity.this.beamSections.isEmpty()) {
                        BeaconBlockEntity.playSound((Level)VampireBeaconBlockEntity.this.level, (BlockPos)VampireBeaconBlockEntity.this.worldPosition, (SoundEvent)SoundEvents.BEACON_POWER_SELECT);
                    }
                    VampireBeaconBlockEntity.this.primaryPower = VampireBeaconBlockEntity.getValidEffectById(value);
                    break;
                }
                case 2: {
                    VampireBeaconBlockEntity.this.effectAmplifier = value;
                    break;
                }
                case 3: {
                    VampireBeaconBlockEntity.this.isUpgraded = value != 0;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public VampireBeaconBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.VAMPIRE_BEACON.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, VampireBeaconBlockEntity pBlockEntity) {
        BlockPos blockpos;
        int i = pPos.getX();
        int j = pPos.getY();
        int k = pPos.getZ();
        if (pBlockEntity.lastCheckY < j) {
            blockpos = pPos;
            pBlockEntity.checkingBeamSections = Lists.newArrayList();
            pBlockEntity.lastCheckY = pPos.getY() - 1;
        } else {
            blockpos = new BlockPos(i, pBlockEntity.lastCheckY + 1, k);
        }
        BeaconBlockEntity.BeaconBeamSection beaconblockentity$beaconbeamsection = pBlockEntity.checkingBeamSections.isEmpty() ? null : pBlockEntity.checkingBeamSections.getLast();
        int l = pLevel.getHeight(Heightmap.Types.WORLD_SURFACE, i, k);
        for (int i1 = 0; i1 < 10 && blockpos.getY() <= l; ++i1) {
            BlockState blockstate = pLevel.getBlockState(blockpos);
            Integer j1 = blockstate.getBeaconColorMultiplier((LevelReader)pLevel, blockpos, pPos);
            if (j1 != null) {
                if (pBlockEntity.checkingBeamSections.size() <= 1) {
                    beaconblockentity$beaconbeamsection = new BeaconBlockEntity.BeaconBeamSection(j1.intValue());
                    pBlockEntity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                } else if (beaconblockentity$beaconbeamsection != null) {
                    if (j1.intValue() == beaconblockentity$beaconbeamsection.getColor()) {
                        ((BeaconBeamSectionyMixin)beaconblockentity$beaconbeamsection).invoke_increaseHeight();
                    } else {
                        beaconblockentity$beaconbeamsection = new BeaconBlockEntity.BeaconBeamSection(FastColor.ARGB32.average((int)beaconblockentity$beaconbeamsection.getColor(), (int)j1));
                        pBlockEntity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                    }
                }
            } else {
                if (beaconblockentity$beaconbeamsection == null || blockstate.getLightBlock((BlockGetter)pLevel, blockpos) >= 15 && !blockstate.is(Blocks.BEDROCK)) {
                    pBlockEntity.checkingBeamSections.clear();
                    pBlockEntity.lastCheckY = l;
                    break;
                }
                ((BeaconBeamSectionyMixin)beaconblockentity$beaconbeamsection).invoke_increaseHeight();
            }
            blockpos = blockpos.above();
            ++pBlockEntity.lastCheckY;
        }
        int k1 = pBlockEntity.levels;
        if (pLevel.getGameTime() % 80L == 0L) {
            if (!pBlockEntity.beamSections.isEmpty()) {
                Pair<Integer, Boolean> integerBooleanPair = VampireBeaconBlockEntity.updateBase(pLevel, i, j, k);
                pBlockEntity.levels = (Integer)integerBooleanPair.getLeft();
                pBlockEntity.isUpgraded = (Boolean)integerBooleanPair.getRight();
            }
            if (pBlockEntity.levels > 0 && !pBlockEntity.beamSections.isEmpty()) {
                pBlockEntity.applyEffects(pLevel, pPos, pBlockEntity.levels, pBlockEntity.primaryPower, pBlockEntity.isUpgraded ? pBlockEntity.effectAmplifier + 1 : pBlockEntity.effectAmplifier);
                BeaconBlockEntity.playSound((Level)pLevel, (BlockPos)pPos, (SoundEvent)SoundEvents.BEACON_AMBIENT);
            }
        }
        if (pBlockEntity.lastCheckY >= l) {
            pBlockEntity.lastCheckY = pLevel.getMinBuildHeight() - 1;
            boolean flag = k1 > 0;
            pBlockEntity.beamSections = pBlockEntity.checkingBeamSections;
            if (!pLevel.isClientSide) {
                boolean flag1;
                boolean bl = flag1 = pBlockEntity.levels > 0;
                if (!flag && flag1) {
                    BeaconBlockEntity.playSound((Level)pLevel, (BlockPos)pPos, (SoundEvent)SoundEvents.BEACON_ACTIVATE);
                    for (ServerPlayer serverplayer : pLevel.getEntitiesOfClass(ServerPlayer.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 3), (double)k).inflate(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.CONSTRUCT_BEACON.trigger(serverplayer, pBlockEntity.levels);
                    }
                } else if (flag && !flag1) {
                    BeaconBlockEntity.playSound((Level)pLevel, (BlockPos)pPos, (SoundEvent)SoundEvents.BEACON_DEACTIVATE);
                }
            }
        }
    }

    protected void applyEffects(Level level, BlockPos pos, int levels, @Nullable Holder<MobEffect> power, int effectAmplifier) {
        if (!level.isClientSide && power != null) {
            if (NO_AMPLIFIER_EFFECTS.contains(power)) {
                effectAmplifier = 0;
            }
            AABB aabb = new AABB(pos).inflate((double)(levels * 10 + 10)).expandTowards(0.0, (double)level.getHeight(), 0.0);
            int effectDuration = (9 + levels * 2) * 20;
            List list = level.getEntitiesOfClass(Player.class, aabb, Helper::isHunter);
            int finalEffectAmplifier = effectAmplifier;
            list.forEach(player -> player.addEffect(new MobEffectInstance(power, effectDuration, finalEffectAmplifier, true, true)));
        }
    }

    private static Pair<Integer, Boolean> updateBase(Level pLevel, int pX, int pY, int pZ) {
        int k;
        int i = 0;
        boolean upgradeFlag = true;
        int j = 1;
        while (j <= 3 && (k = pY - j) >= pLevel.getMinBuildHeight()) {
            boolean flag = true;
            boolean upgradeFlagLevel = upgradeFlag;
            block1: for (int l = pX - j; l <= pX + j && flag; ++l) {
                for (int i1 = pZ - j; i1 <= pZ + j; ++i1) {
                    BlockState blockState = pLevel.getBlockState(new BlockPos(l, k, i1));
                    if (!blockState.is(ModTags.Blocks.VAMPIRE_BEACON_BASE_BLOCKS)) {
                        flag = false;
                        continue block1;
                    }
                    if (!upgradeFlagLevel) continue;
                    upgradeFlagLevel = blockState.is(ModTags.Blocks.VAMPIRE_BEACON_BASE_ENHANCED_BLOCKS);
                }
            }
            if (!flag) break;
            upgradeFlag = upgradeFlag && upgradeFlagLevel;
            i = j++;
        }
        return Pair.of((Object)i, (Object)upgradeFlag);
    }

    public void setRemoved() {
        BeaconBlockEntity.playSound((Level)this.level, (BlockPos)this.worldPosition, (SoundEvent)SoundEvents.BEACON_DEACTIVATE);
        super.setRemoved();
    }

    public List<BeaconBlockEntity.BeaconBeamSection> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    static Holder<MobEffect> getValidEffectById(int pEffectId) {
        Holder mobeffect = BeaconMenu.decodeEffect((int)pEffectId);
        return VALID_EFFECTS.contains(mobeffect) ? mobeffect : null;
    }

    public void loadAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.primaryPower = VampireBeaconBlockEntity.getValidEffectById(pTag.getInt("Primary"));
        if (pTag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)pTag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        this.effectAmplifier = pTag.getInt("Amplifier");
        this.lockKey = LockCode.fromTag((CompoundTag)pTag);
        this.isUpgraded = pTag.getBoolean("Upgraded");
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        pTag.putInt("Primary", BeaconMenu.encodeEffect(this.primaryPower));
        pTag.putInt("Levels", this.levels);
        if (this.name != null) {
            pTag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
        pTag.putInt("Amplifier", this.effectAmplifier);
        this.lockKey.addToTag(pTag);
        pTag.putBoolean("Upgraded", this.isUpgraded);
    }

    public void setCustomName(@Nullable Component pName) {
        this.name = pName;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return BaseContainerBlockEntity.canUnlock((Player)pPlayer, (LockCode)this.lockKey, (Component)this.getDisplayName()) ? new VampireBeaconMenu(pContainerId, (Container)pPlayerInventory, this.dataAccess, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos())) : null;
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @NotNull
    public Component getName() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    public void setLevel(@NotNull Level pLevel) {
        super.setLevel(pLevel);
        this.lastCheckY = pLevel.getMinBuildHeight() - 1;
    }
}

