/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.Maps;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CandleStickBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.getValue((Property)LIT) != false ? 6 : 0;
    private final Map<ResourceLocation, Supplier<Block>> fullHolderByContent = Maps.newHashMap();
    @Nullable
    protected final Supplier<? extends Block> emptyBlock;
    @NotNull
    protected final Supplier<Item> candle;

    protected static <T extends CandleStickBlock> Products.P3<RecordCodecBuilder.Mu<T>, Block, Item, BlockBehaviour.Properties> candleStickParts(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("empty_block").forGetter(i -> i.emptyBlock.get()), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("candle").forGetter(i -> i.candle.get()), (App)CandleStickBlock.propertiesCodec());
    }

    protected CandleStickBlock(@Nullable Supplier<? extends Block> emptyBlock, @NotNull Supplier<Item> candle, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.emptyBlock = emptyBlock;
        this.candle = candle;
    }

    public void addCandle(ResourceLocation candle, Supplier<Block> holder) {
        if (candle == null) {
            throw new IllegalArgumentException("Cannot add plant to non-empty candle mount");
        }
        this.fullHolderByContent.put(candle, holder);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHit) {
        ItemStack stack = pPlayer.getItemInHand(InteractionHand.MAIN_HAND);
        Item item = stack.getItem();
        if (this.isEmpty()) {
            Block orDefault = this.fullHolderByContent.getOrDefault(BuiltInRegistries.ITEM.getKey((Object)item), () -> Blocks.AIR).get();
            if (orDefault != Blocks.AIR) {
                pLevel.setBlock(pPos, this.getFilledState(pState, orDefault), 3);
                if (!pPlayer.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
        } else if (pPlayer.getAbilities().mayBuild && pPlayer.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
                CandleStickBlock.extinguish((Player)pPlayer, (BlockState)pState, (LevelAccessor)pLevel, (BlockPos)pPos);
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            }
            if (this.emptyBlock != null) {
                pLevel.setBlock(pPos, this.getEmptyState(pState, this.emptyBlock.get()), 3);
                if (!pPlayer.getAbilities().instabuild) {
                    pPlayer.addItem(this.candle.get().getDefaultInstance());
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected BlockState getFilledState(BlockState sourceState, Block block) {
        return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)((Boolean)sourceState.getValue((Property)WATERLOGGED)))).setValue((Property)LIT, (Comparable)((Boolean)sourceState.getValue((Property)LIT)));
    }

    protected BlockState getEmptyState(BlockState sourceState, Block block) {
        return (BlockState)((BlockState)block.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)((Boolean)sourceState.getValue((Property)WATERLOGGED)))).setValue((Property)LIT, (Comparable)((Boolean)sourceState.getValue((Property)LIT)));
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @NotNull
    public FluidState getFluidState(@NotNull BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT, WATERLOGGED});
    }

    public boolean placeLiquid(@NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull FluidState pFluidState) {
        if (!((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue() && pFluidState.getType() == Fluids.WATER) {
            BlockState blockstate = (BlockState)pState.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
            if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
                CandleStickBlock.extinguish((Player)null, (BlockState)blockstate, (LevelAccessor)pLevel, (BlockPos)pPos);
            } else {
                pLevel.setBlock(pPos, blockstate, 3);
            }
            pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    protected boolean canBeLit(@NotNull BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) == false && !this.isEmpty() && super.canBeLit(pState);
    }

    public boolean canSurvive(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        return Block.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.below(), (Direction)Direction.UP);
    }

    public static boolean canLight(@NotNull BlockState pState) {
        return pState.is(BlockTags.CANDLES, p_152810_ -> p_152810_.hasProperty((Property)LIT) && p_152810_.hasProperty((Property)WATERLOGGED)) && (Boolean)pState.getValue((Property)LIT) == false && (Boolean)pState.getValue((Property)WATERLOGGED) == false;
    }

    public @NotNull Supplier<@Nullable Item> getCandle() {
        return this.candle;
    }

    public boolean isEmpty() {
        return this.candle.get() == null;
    }
}

