/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.SunscreenBeaconBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SunscreenBeaconBlock
extends VampirismBlockContainer {
    public static final MapCodec<SunscreenBeaconBlock> CODEC = SunscreenBeaconBlock.simpleCodec(SunscreenBeaconBlock::new);

    public SunscreenBeaconBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return level.isClientSide() ? null : SunscreenBeaconBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.SUNSCREEN_BEACON.get()), SunscreenBeaconBlockEntity::serverTick);
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag advanced) {
        super.appendHoverText(stack, context, tooltip, advanced);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip1")).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip2"), (Object[])new Object[]{VampirismConfig.SERVER.sunscreenBeaconDistance.get()}).withStyle(ChatFormatting.GRAY));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return (Boolean)VampirismConfig.SERVER.sunscreenBeaconMineable.get();
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return (Boolean)VampirismConfig.SERVER.sunscreenBeaconMineable.get() != false ? 50.0f : -1.0f;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)VampirismConfig.SERVER.sunscreenBeaconMineable.get() != false ? 50.0f : 3600000.0f;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new SunscreenBeaconBlockEntity(pos, state);
    }
}

