/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.client.gui.screens.SelectActionRadialScreen;
import de.teamlapen.vampirism.client.gui.screens.SelectAmmoScreen;
import de.teamlapen.vampirism.client.gui.screens.SelectMinionTaskRadialScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.network.ServerboundStartFeedingPacket;
import de.teamlapen.vampirism.network.ServerboundToggleActionPacket;
import de.teamlapen.vampirism.util.RegUtil;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModKeys {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long ACTION_BUTTON_COOLDOWN = 500L;
    private static final String CATEGORY = "keys.vampirism.category";
    public static final KeyMapping SUCK = new KeyMapping("keys.vampirism.suck", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "keys.vampirism.category");
    public static final KeyMapping ACTION = new KeyMapping("keys.vampirism.action", InputConstants.Type.KEYSYM, 82, "keys.vampirism.category");
    public static final KeyMapping VAMPIRISM_MENU = new KeyMapping("keys.vampirism.select_skills", InputConstants.Type.KEYSYM, 80, "keys.vampirism.category");
    public static final KeyMapping VISION = new KeyMapping("keys.vampirism.vision", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 78, "keys.vampirism.category");
    public static final KeyMapping ACTION1 = new KeyMapping("keys.vampirism.action1", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 49, "keys.vampirism.category");
    public static final KeyMapping ACTION2 = new KeyMapping("keys.vampirism.action2", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 50, "keys.vampirism.category");
    public static final KeyMapping ACTION3 = new KeyMapping("keys.vampirism.action3", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 51, "keys.vampirism.category");
    public static final KeyMapping ACTION4 = new KeyMapping("keys.vampirism.action4", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping ACTION5 = new KeyMapping("keys.vampirism.action5", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping ACTION6 = new KeyMapping("keys.vampirism.action6", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping ACTION7 = new KeyMapping("keys.vampirism.action7", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping ACTION8 = new KeyMapping("keys.vampirism.action8", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping ACTION9 = new KeyMapping("keys.vampirism.action9", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping MINION = new KeyMapping("keys.vampirism.minion_task", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final KeyMapping SELECT_AMMO = new KeyMapping("keys.vampirism.select_ammo", InputConstants.Type.KEYSYM, 67, "keys.vampirism.category");
    public static final KeyMapping SKILL_SCREEN = new KeyMapping("keys.vampirism.skill_screen", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "keys.vampirism.category");
    public static final Map<Integer, KeyMapping> ACTION_KEYS = Map.of(1, ACTION1, 2, ACTION2, 3, ACTION3, 4, ACTION4, 5, ACTION5, 6, ACTION6, 7, ACTION7, 8, ACTION8, 9, ACTION9);
    private boolean suckKeyDown = false;
    private final Map<KeyMapping, Runnable> keyMappingActions;
    private final Minecraft mc;
    private final Int2LongArrayMap actionTriggerTime = new Int2LongArrayMap();

    static void registerKeyMapping(@NotNull RegisterKeyMappingsEvent event) {
        event.register(ACTION);
        event.register(SUCK);
        event.register(VAMPIRISM_MENU);
        event.register(VISION);
        event.register(MINION);
        event.register(SELECT_AMMO);
        event.register(SKILL_SCREEN);
        ACTION_KEYS.forEach((i, k) -> event.register(k));
    }

    public ModKeys() {
        ImmutableMap.Builder keyMappingActions = ImmutableMap.builder();
        keyMappingActions.put((Object)ACTION, this::openActionMenu);
        keyMappingActions.put((Object)VAMPIRISM_MENU, this::openVampirismMenu);
        keyMappingActions.put((Object)VISION, this::switchVision);
        keyMappingActions.put((Object)MINION, this::openMinionTaskMenu);
        keyMappingActions.put((Object)SELECT_AMMO, this::selectAmmo);
        keyMappingActions.put((Object)SKILL_SCREEN, this::openSkillScreen);
        ACTION_KEYS.forEach((i, key) -> keyMappingActions.put(key, () -> this.toggleAction((int)i)));
        this.keyMappingActions = keyMappingActions.build();
        this.mc = Minecraft.getInstance();
    }

    @SubscribeEvent
    public void handleMouseButton(InputEvent.MouseButton.Pre event) {
        this.handleInputEvent((InputEvent)event, event.getAction());
    }

    @SubscribeEvent
    public void handleKey(InputEvent.Key event) {
        this.handleInputEvent((InputEvent)event, event.getAction());
    }

    public void handleInputEvent(InputEvent event, int action) {
        if (SUCK.isDown()) {
            this.suck();
        } else {
            this.endSuck();
            if (action == 1) {
                for (Map.Entry<KeyMapping, Runnable> entry : this.keyMappingActions.entrySet()) {
                    if (!entry.getKey().isDown()) continue;
                    entry.getValue().run();
                    break;
                }
            }
        }
    }

    private void suck() {
        if (!this.suckKeyDown) {
            VampirePlayer vampire;
            HitResult mouseOver = Minecraft.getInstance().hitResult;
            this.suckKeyDown = true;
            LocalPlayer player = Minecraft.getInstance().player;
            if (mouseOver != null && !player.isSpectator() && (vampire = VampirePlayer.get((Player)player)).getLevel() > 0 && !vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get())) {
                if (mouseOver instanceof EntityHitResult) {
                    VampirismMod.proxy.sendToServer(new ServerboundStartFeedingPacket(((EntityHitResult)mouseOver).getEntity().getId()));
                } else if (mouseOver instanceof BlockHitResult) {
                    BlockPos pos = ((BlockHitResult)mouseOver).getBlockPos();
                    VampirismMod.proxy.sendToServer(new ServerboundStartFeedingPacket(pos));
                } else {
                    LOGGER.warn("Unknown mouse over type while trying to feed");
                }
            }
        }
    }

    private void endSuck() {
        if (this.suckKeyDown) {
            this.suckKeyDown = false;
            VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.FINISH_SUCK_BLOOD));
        }
    }

    private void openActionMenu() {
        if (this.mc.player.isAlive() && !this.mc.player.isSpectator()) {
            SelectActionRadialScreen.show();
        }
    }

    private void openVampirismMenu() {
        VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.VAMPIRISM_MENU));
    }

    private void openSkillScreen() {
        FactionPlayerHandler.getCurrentFactionPlayer((Player)this.mc.player).ifPresent(factionPlayer -> this.mc.setScreen((Screen)new SkillsScreen((IFactionPlayer<?>)factionPlayer, this.mc.screen)));
    }

    private void switchVision() {
        VampirismMod.proxy.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Event.TOGGLE_VAMPIRE_VISION));
    }

    private void openMinionTaskMenu() {
        if (Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        if (FactionPlayerHandler.get((Player)this.mc.player).getLordLevel() > 0) {
            SelectMinionTaskRadialScreen.show();
        }
    }

    private void toggleAction(int id) {
        long t = System.currentTimeMillis();
        if (t - this.actionTriggerTime.getOrDefault(id, 0L) > 500L) {
            this.actionTriggerTime.put(id, t);
            LocalPlayer player = this.mc.player;
            if (player.isAlive()) {
                FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
                handler.getCurrentFactionPlayer().ifPresent(factionPlayer -> this.toggleBoundAction((IFactionPlayer<?>)factionPlayer, handler.getBoundAction(id)));
            }
        }
    }

    private void toggleBoundAction(@NotNull IFactionPlayer<?> player, @Nullable IAction<?> action) {
        if (action == null) {
            player.asEntity().displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.not_bound", (Object[])new Object[]{"/vampirism bind-action"}), true);
        } else if (action.getFaction().map(faction -> !faction.equals(player.getFaction())).orElse(false).booleanValue()) {
            player.asEntity().displayClientMessage((Component)Component.translatable((String)"text.vampirism.action.only_faction", (Object[])new Object[]{action.getFaction().get().getName()}), true);
        } else {
            VampirismMod.proxy.sendToServer(ServerboundToggleActionPacket.createFromRaytrace(RegUtil.id(action), Minecraft.getInstance().hitResult));
        }
    }

    private void selectAmmo() {
        if (this.mc.player.isAlive()) {
            SelectAmmoScreen.show();
        }
    }
}

