/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IFactionMinionTask;
import de.teamlapen.vampirism.api.entity.minion.INoGlobalCommandTask;
import de.teamlapen.vampirism.api.util.ItemOrdering;
import de.teamlapen.vampirism.client.ClientConfigHelper;
import de.teamlapen.vampirism.client.gui.screens.SelectMinionTaskRadialScreen;
import de.teamlapen.vampirism.client.gui.screens.radial.edit.ReorderingGuiRadialMenu;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSelectMinionTaskScreen
extends ReorderingGuiRadialMenu<SelectMinionTaskRadialScreen.Entry> {
    public EditSelectMinionTaskScreen(FactionPlayerHandler player) {
        super(EditSelectMinionTaskScreen.getOrdering(player), entry -> entry.getText().plainCopy(), EditSelectMinionTaskScreen::drawActionPart, ordering -> EditSelectMinionTaskScreen.saveOrdering(player, ordering), item -> EditSelectMinionTaskScreen.isEnabled(player, item));
    }

    public static void show() {
        Minecraft.getInstance().setScreen((Screen)new EditSelectMinionTaskScreen(FactionPlayerHandler.get((Player)Minecraft.getInstance().player)));
    }

    private static void drawActionPart(@Nullable SelectMinionTaskRadialScreen.Entry entry, GuiGraphics graphics, int posX, int posY, int size, boolean transparent) {
        if (entry == null) {
            return;
        }
        graphics.blit(entry.getIconLoc(), posX, posY, 0, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static boolean isEnabled(FactionPlayerHandler player, @NotNull SelectMinionTaskRadialScreen.Entry item) {
        return player.getCurrentFactionPlayer().flatMap(fp -> Optional.ofNullable(item.getTask()).map(task -> task.isAvailable((IPlayableFaction<?>)fp.getFaction(), player))).orElse(true);
    }

    private static ItemOrdering<SelectMinionTaskRadialScreen.Entry> getOrdering(FactionPlayerHandler player) {
        return new ItemOrdering<SelectMinionTaskRadialScreen.Entry>(ClientConfigHelper.getMinionTaskOrder(player.getCurrentFaction()), new ArrayList(), () -> Stream.concat(ModRegistries.MINION_TASKS.stream().filter(s -> !(s instanceof INoGlobalCommandTask)).filter(s -> {
            if (s instanceof IFactionMinionTask) {
                IFactionMinionTask factionTask = (IFactionMinionTask)s;
                if (factionTask.getFaction() == null) {
                    return true;
                }
                return factionTask.getFaction() == player.getCurrentFaction();
            }
            return true;
        }).map(SelectMinionTaskRadialScreen.Entry::new), SelectMinionTaskRadialScreen.CUSTOM_ENTRIES.values().stream()).toList());
    }

    private static void saveOrdering(FactionPlayerHandler player, ItemOrdering<SelectMinionTaskRadialScreen.Entry> ordering) {
        ClientConfigHelper.saveMinionTaskOrder(player.getCurrentFaction(), ordering.getOrdering());
    }
}

