/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsScreen;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsTabScreen;
import de.teamlapen.vampirism.data.ClientSkillTreeData;
import de.teamlapen.vampirism.entity.player.skills.ActionSkill;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeConfiguration;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillNodeScreen {
    private static final ResourceLocation SKILL_BACKGROUND_SPRITE = VResourceLocation.mod("skills_screen/node");
    private static final ResourceLocation START_SKILL_BACKGROUND_SPRITE = VResourceLocation.mod("skills_screen/start_node");
    private static final ResourceLocation TITLE_RED_SPRITE = VResourceLocation.mod("skills_screen/title_red");
    private static final ResourceLocation TITLE_BLUE_SPRITE = VResourceLocation.mod("skills_screen/title_blue");
    private static final ResourceLocation TITLE_GREEN_SPRITE = VResourceLocation.mod("skills_screen/title_green");
    private static final ResourceLocation DESCRIPTION_SPRITE = VResourceLocation.mod("skills_screen/description");
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final Minecraft minecraft;
    private final SkillsTabScreen tab;
    private final SkillsScreen screen;
    private final SkillTreeConfiguration.SkillTreeNodeConfiguration skillNode;
    private final ClientSkillTreeData treeData;
    private final SkillHandler<?> skillHandler;
    private final List<SkillNodeScreen> children = new ArrayList<SkillNodeScreen>();
    @Nullable
    private final SkillNodeScreen parent;
    private final int x;
    private final int y;
    private final FormattedCharSequence[] titles;
    private final List<FormattedCharSequence>[] descriptions;
    private final int[] width;

    public SkillNodeScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, @NotNull SkillsTabScreen tab, @NotNull SkillTreeConfiguration.SkillTreeNodeConfiguration skillNode, ClientSkillTreeData treeData, @NotNull SkillHandler<?> skillHandler) {
        this(minecraft, screen, tab, skillNode, treeData, skillHandler, null, 0, 0);
    }

    public SkillNodeScreen(@NotNull Minecraft minecraft, @NotNull SkillsScreen screen, @NotNull SkillsTabScreen tab, @NotNull SkillTreeConfiguration.SkillTreeNodeConfiguration skillNode, ClientSkillTreeData treeData, @NotNull SkillHandler<?> skillHandler, @Nullable SkillNodeScreen parent, int x, int y) {
        int i;
        this.minecraft = minecraft;
        this.tab = tab;
        this.screen = screen;
        this.skillNode = skillNode;
        this.treeData = treeData;
        this.skillHandler = skillHandler;
        this.parent = parent;
        this.x = x;
        this.y = y;
        int w = this.treeData.getNodeWidth(skillNode);
        int childrenCount = this.skillNode.children().size();
        if (childrenCount > 0) {
            int pos = x;
            if (--childrenCount > 0) {
                pos -= w / 2 - 13;
            }
            for (i = 0; i < skillNode.childrenCount(); ++i) {
                SkillTreeConfiguration.SkillTreeNodeConfiguration current = skillNode.children().get(i);
                this.children.add(new SkillNodeScreen(minecraft, screen, tab, current, this.treeData, skillHandler, this, pos, y + 60));
                pos += this.treeData.getNodeWidth(current) / 2 + 30;
                if (skillNode.children().size() < i + 2) continue;
                SkillTreeConfiguration.SkillTreeNodeConfiguration next = skillNode.children().get(i + 1);
                pos += this.treeData.getNodeWidth(next) / 2;
            }
        }
        this.titles = new FormattedCharSequence[skillNode.elementCount()];
        this.descriptions = new List[skillNode.elementCount()];
        this.width = new int[skillNode.elementCount()];
        int l = 56;
        for (i = 0; i < skillNode.elementCount(); ++i) {
            this.titles[i] = Language.getInstance().getVisualOrder(minecraft.font.substrByWidth((FormattedText)((ISkill)skillNode.elements().get(i).value()).getName(), 163));
            int size = Math.max(l + minecraft.font.width(this.titles[i]), 120);
            this.descriptions[i] = Language.getInstance().getVisualOrder(this.findOptimalLines((Component)ComponentUtils.mergeStyles((MutableComponent)Optional.ofNullable(((ISkill)skillNode.elements().get(i).value()).getDescription()).orElse((Component)Component.empty()).copy(), (Style)Style.EMPTY.withColor(ChatFormatting.GRAY)), size - 30));
            this.width[i] = size;
        }
    }

    private static float getMaxWidth(@NotNull StringSplitter p_238693_0_, @NotNull List<FormattedText> p_238693_1_) {
        return (float)p_238693_1_.stream().mapToDouble(arg_0 -> ((StringSplitter)p_238693_0_).stringWidth(arg_0)).max().orElse(0.0);
    }

    private SkillNodeState getState() {
        block6: {
            block5: {
                if (this.skillNode.elements().stream().anyMatch(this.skillHandler::isSkillEnabled)) {
                    return SkillNodeState.UNLOCKED;
                }
                if (this.skillHandler.isSkillNodeLocked((ISkillNode)this.skillNode.node().value())) {
                    return SkillNodeState.LOCKED;
                }
                if (this.skillNode.isRoot()) break block5;
                if (!this.treeData.getParent(this.skillNode).stream().flatMap(s -> ((ISkillNode)s.value()).skills().stream()).anyMatch(this.skillHandler::isSkillEnabled)) break block6;
            }
            return SkillNodeState.AVAILABLE;
        }
        return SkillNodeState.VISIBLE;
    }

    private List<ISkill<?>> getLockingSkills(SkillTreeConfiguration.SkillTreeNodeConfiguration node) {
        Registry nodes = this.minecraft.level.registryAccess().registryOrThrow(VampirismRegistries.Keys.SKILL_NODE);
        return ((ISkillNode)node.node().value()).lockingNodes().stream().flatMap(x -> nodes.getOptional(x).stream()).flatMap(x -> x.skills().stream()).map(Holder::value).collect(Collectors.toList());
    }

    public List<SkillNodeScreen> getChildren() {
        return this.children;
    }

    public SkillTreeConfiguration.SkillTreeNodeConfiguration getSkillNode() {
        return this.skillNode;
    }

    public void draw(@NotNull GuiGraphics graphics, int i, int j) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        int width = this.getNodeWidth();
        pose.translate((float)(-width) / 2.0f, 0.0f, 50.0f);
        int x = i + this.getNodeStart();
        if (this.skillNode.elementCount() > 1) {
            graphics.blitSprite(SKILL_BACKGROUND_SPRITE, x, this.y + j, width, 26);
        }
        for (int i1 = 0; i1 < this.skillNode.elementCount(); ++i1) {
            if (state == SkillNodeState.LOCKED || !this.skillHandler.isSkillEnabled(this.skillNode.elements().get(i1))) {
                graphics.setColor(0.5f, 0.5f, 0.5f, 1.0f);
            } else {
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            graphics.blitSprite(this.skillNode.isRoot() ? START_SKILL_BACKGROUND_SPRITE : SKILL_BACKGROUND_SPRITE, x, this.y + j, 26, 26);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.enableBlend();
            graphics.blit(this.getSkillIconLocation((ISkill)this.skillNode.elements().get(i1).value()), x + 5, this.y + j + 5, 0.0f, 0.0f, 16, 16, 16, 16);
            x += 36;
        }
        pose.popPose();
        for (SkillNodeScreen child : this.children) {
            child.draw(graphics, i, j);
        }
    }

    public void drawConnectivity(@NotNull GuiGraphics graphics, int startX, int startY, boolean outerLine) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        if (this.parent != null) {
            int color = state.pathColor(outerLine);
            PoseStack pose = graphics.pose();
            pose.pushPose();
            if (state == SkillNodeState.UNLOCKED) {
                pose.translate(0.0f, 0.0f, 10.0f);
            }
            int i = startX + this.x;
            int i1 = startX + this.parent.x;
            int j = startY + this.y - 30;
            int j2 = startY + this.parent.y + 13;
            int j3 = startY + this.y - 29;
            int j4 = startY + this.parent.y + 13 + 16;
            int i2 = startX + this.x;
            int j5 = startY + this.y;
            int i3 = startX + this.parent.x;
            if (outerLine) {
                graphics.hLine(i, i1, j - 1, color);
                graphics.hLine(i, i1, j + 1, color);
                graphics.vLine(i1 - 1, j2, j3, color);
                graphics.vLine(i3 + 1, j2, j3, color);
                graphics.vLine(i - 1, j4, j5 + 1, color);
                graphics.vLine(i2 + 1, j4, j5 + 1, color);
            } else {
                graphics.hLine(i, i1, j, color);
                graphics.vLine(i1, j2, j3, color);
                graphics.vLine(i, j4, j5 + 1, color);
            }
            pose.popPose();
        }
        for (SkillNodeScreen child : this.children) {
            child.drawConnectivity(graphics, startX, startY, outerLine);
        }
    }

    private int getNodeWidth() {
        return 26 * this.skillNode.elementCount() + (this.skillNode.elementCount() - 1) * 10;
    }

    public void drawHover(@NotNull GuiGraphics graphics, double mouseX, double mouseY, float fade, int scrollX, int scrollY) {
        SkillNodeState state = this.getState();
        if (state == SkillNodeState.HIDDEN) {
            return;
        }
        Holder[] elements = (Holder[])this.skillNode.elements().toArray(Holder[]::new);
        scrollX -= (int)((float)this.getNodeWidth() / 2.0f);
        int hoveredSkillIndex = -1;
        for (int i = 0; i < elements.length; ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, scrollX, scrollY)) continue;
            hoveredSkillIndex = i;
            break;
        }
        if (hoveredSkillIndex != -1) {
            Holder hoveredSkill = elements[hoveredSkillIndex];
            int x = this.getNodeStart() + 36 * hoveredSkillIndex;
            List<ISkill<?>> lockingSkills = this.getLockingSkills(this.skillNode);
            if (state == SkillNodeState.LOCKED || state == SkillNodeState.VISIBLE) {
                ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
                if (state == SkillNodeState.VISIBLE) {
                    MutableComponent t1 = Component.translatable((String)"text.vampirism.skill.unlock_parent_first").withStyle(ChatFormatting.DARK_RED);
                    text.add(t1);
                } else {
                    text.add(Component.translatable((String)"text.vampirism.skill.locked"));
                    lockingSkills.stream().map(a -> a.getName().copy().withStyle(ChatFormatting.DARK_RED)).forEach(text::add);
                }
                int width = text.stream().mapToInt(arg_0 -> ((Font)this.minecraft.font).width(arg_0)).max().getAsInt();
                graphics.blitSprite(DESCRIPTION_SPRITE, scrollX + x - 3, scrollY + this.y - 3 - text.size() * 9, width + 8, 10 + text.size() * 10);
                int fontY = scrollY + this.y + 1 - text.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    graphics.drawString(this.minecraft.font, (Component)text.get(i), scrollX + x + 2, fontY + i * 9, -1, true);
                }
            }
            List<FormattedCharSequence> description = this.descriptions[hoveredSkillIndex];
            if (!lockingSkills.isEmpty()) {
                ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
                text.add(Component.translatable((String)"text.vampirism.skill.excluding"));
                lockingSkills.stream().map(a -> a.getName().copy().withStyle(ChatFormatting.YELLOW)).forEach(text::add);
                int width = Math.min(this.width[hoveredSkillIndex], text.stream().mapToInt(arg_0 -> ((Font)this.minecraft.font).width(arg_0)).max().getAsInt());
                int yOffset = description.isEmpty() ? 15 : 24;
                graphics.blitSprite(DESCRIPTION_SPRITE, scrollX + x - 3, scrollY + this.y + 3 + 7 + description.size() * 9, width + 8, 10 + text.size() * 10 + yOffset);
                int fontY = scrollY + this.y + 3 + yOffset + 8 + description.size() * 9;
                for (int i = 0; i < text.size(); ++i) {
                    graphics.drawString(this.minecraft.font, (Component)text.get(i), scrollX + x + 2, fontY + i * 9, -1, true);
                }
            }
            if (!description.isEmpty()) {
                graphics.blitSprite(DESCRIPTION_SPRITE, scrollX + x - 5, scrollY + this.y + 3, this.width[hoveredSkillIndex], 30 + description.size() * 9);
                for (int i = 0; i < description.size(); ++i) {
                    graphics.drawString(this.minecraft.font, description.get(i), scrollX + x + 2, scrollY + this.y + 3 + 24 + i * 9, -1, true);
                }
            }
            ResourceLocation texture = state.sprite;
            if (state == SkillNodeState.UNLOCKED && !this.skillHandler.isSkillEnabled(hoveredSkill)) {
                texture = SkillNodeState.LOCKED.sprite;
            }
            graphics.blitSprite(texture, scrollX + x - 5, scrollY + this.y + 3, this.width[hoveredSkillIndex], 20);
            graphics.drawString(this.minecraft.font, this.titles[hoveredSkillIndex], scrollX + x + 40, scrollY + this.y + 9, -1, true);
            if (!this.skillNode.isRoot()) {
                int cost = ((ISkill)hoveredSkill.value()).getSkillPointCost();
                int costWidth = this.minecraft.font.width(String.valueOf(cost));
                Objects.requireNonNull(this.minecraft.font);
                int costHeight = 9;
                graphics.blitSprite(DESCRIPTION_SPRITE, scrollX + x + 24, scrollY + this.y + (26 - costHeight) / 2 - 1, costWidth + 5, costHeight + 4);
                graphics.drawString(this.minecraft.font, (Component)Component.literal((String)String.valueOf(cost)), scrollX + x + 27, (int)((float)(scrollY + this.y) + (float)(26 - costHeight) / 2.0f + 1.0f), -1, true);
            }
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.blitSprite(this.skillNode.isRoot() ? START_SKILL_BACKGROUND_SPRITE : SKILL_BACKGROUND_SPRITE, scrollX + x, scrollY + this.y, 26, 26);
            RenderSystem.enableBlend();
            graphics.blit(this.getSkillIconLocation((ISkill)hoveredSkill.value()), x + scrollX + 5, this.y + scrollY + 5, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private List<FormattedCharSequence> getSkillDescription(int skill) {
        List<FormattedCharSequence> description = this.descriptions[skill];
        ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled((ISkill)this.skillNode.elements().get(skill).value());
        List<ISkill<?>> lockingSkills = null;
        ChatFormatting lockingColor = ChatFormatting.BLACK;
        if (!((ISkillNode)this.skillNode.node().value()).lockingNodes().isEmpty()) {
            lockingSkills = this.getLockingSkills(this.skillNode);
            ChatFormatting chatFormatting = result == ISkillHandler.Result.ALREADY_ENABLED ? ChatFormatting.DARK_GRAY : (lockingColor = lockingSkills.stream().anyMatch(this.skillHandler::isSkillEnabled) ? ChatFormatting.DARK_RED : ChatFormatting.YELLOW);
        }
        if (lockingSkills != null) {
            int l = 56;
            int size = Math.max(l + this.minecraft.font.width(this.titles[skill]), 120) - 20;
            description = new ArrayList<FormattedCharSequence>(description);
            description.addAll(Language.getInstance().getVisualOrder(this.findOptimalLines((Component)Component.translatable((String)"text.vampirism.skill.excluding").withStyle(lockingColor), size)));
            for (ISkill<?> lockingSkill : lockingSkills) {
                description.addAll(Language.getInstance().getVisualOrder(this.findOptimalLines((Component)Component.literal((String)"  ").append((Component)lockingSkill.getName().copy().withStyle(lockingColor)), size)));
            }
        }
        return description;
    }

    private ResourceLocation getSkillIconLocation(@NotNull ISkill skill) {
        if (skill instanceof ActionSkill) {
            return VResourceLocation.loc(((ActionSkill)skill).getActionID().getNamespace(), "textures/actions/" + ((ActionSkill)skill).getActionID().getPath() + ".png");
        }
        ResourceLocation id = RegUtil.id(skill);
        return VResourceLocation.loc(id.getNamespace(), "textures/skills/" + id.getPath() + ".png");
    }

    public boolean isMouseOver(double mouseX, double mouseY, int scrollX, int scrollY) {
        double width = this.getNodeWidth();
        return mouseX >= (double)(this.x + scrollX) - width / 2.0 && mouseX < (double)(this.x + scrollX) + width / 2.0 - 1.0 && mouseY > (double)(scrollY + this.y) && mouseY < (double)(scrollY + this.y + 26);
    }

    public boolean isMouseOverSkill(int index, double mouseX, double mouseY, int guiLeft, int guiTop) {
        int x = this.x + 36 * index;
        return mouseX > (double)(x + guiLeft) && mouseX < (double)(x + guiLeft + 26) && mouseY > (double)(guiTop + this.y) && mouseY < (double)(guiTop + this.y + 26);
    }

    @Nullable
    public ISkill getSelectedSkill(double mouseX, double mouseY, int scrollX, int scrollY) {
        if (!this.isMouseOver(mouseX, mouseY, scrollX, scrollY)) {
            return null;
        }
        int nodeWidth = this.getNodeWidth();
        for (int i = 0; i < this.skillNode.elementCount(); ++i) {
            if (!this.isMouseOverSkill(i, mouseX, mouseY, (int)((float)scrollX - (float)nodeWidth / 2.0f), scrollY)) continue;
            return (ISkill)this.skillNode.elements().get(i).value();
        }
        return null;
    }

    private int getNodeStart() {
        int x = this.x;
        return x;
    }

    private List<FormattedText> findOptimalLines(@NotNull Component p_238694_1_, int p_238694_2_) {
        StringSplitter charactermanager = this.minecraft.font.getSplitter();
        List list = Collections.emptyList();
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list1 = charactermanager.splitLines((FormattedText)p_238694_1_, p_238694_2_ - i, Style.EMPTY);
            float f1 = Math.abs(SkillNodeScreen.getMaxWidth(charactermanager, list1) - (float)p_238694_2_);
            if (f1 <= 10.0f) {
                return list1;
            }
            if (!(f1 < f)) continue;
            f = f1;
            list = list1;
        }
        return list;
    }

    static enum SkillNodeState {
        AVAILABLE(TITLE_BLUE_SPRITE, -5789785, -1),
        HIDDEN(null, 0, 0),
        LOCKED(TITLE_RED_SPRITE, -3211264, -9830400),
        UNLOCKED(TITLE_GREEN_SPRITE, -16742639, -16755964),
        VISIBLE(TITLE_BLUE_SPRITE, -14540254, -12632257);

        public final ResourceLocation sprite;
        public final int innerColor;
        public final int outerColor;

        private SkillNodeState(ResourceLocation sprite, int innerColor, int outerColor) {
            this.sprite = sprite;
            this.outerColor = outerColor;
            this.innerColor = innerColor;
        }

        int pathColor(boolean outer) {
            return outer ? this.outerColor : this.innerColor;
        }
    }
}

