/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAttachments;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.items.CrucifixItem;
import de.teamlapen.vampirism.mixin.client.accessor.CameraAccessor;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.MixinHooks;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderHandler
implements ResourceManagerReloadListener {
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @NotNull
    private final Minecraft mc;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int VAMPIRE_BIOME_FADE_TICKS = 60;
    private final Logger LOGGER = LogManager.getLogger();
    private Buffers bloodVisionBuffer = new Buffers();
    private int vampireBiomeTicks = 0;
    private boolean insideFog = false;
    private int bloodVisionTicks = 0;
    private int lastBloodVisionTicks = 0;
    private float vampireBiomeFogDistanceMultiplier = 1.0f;
    @Nullable
    private PostChain blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean reducedBloodVision = false;
    @Nullable
    private PostPass blur1;
    @Nullable
    private PostPass blur2;
    @Nullable
    private PostPass blit0;
    private boolean isInsideBloodVisionRendering = false;

    public RenderHandler(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void onCameraSetup(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ViewportEvent.ComputeCameraAngles event) {
        if (this.shouldRenderBloodVision()) {
            this.reducedBloodVision = OptifineHandler.isShaders();
            if (!this.reducedBloodVision) {
                if (this.displayHeight != this.mc.getWindow().getHeight() || this.displayWidth != this.mc.getWindow().getWidth()) {
                    this.displayHeight = this.mc.getWindow().getHeight();
                    this.displayWidth = this.mc.getWindow().getWidth();
                    this.updateFramebufferSize(this.displayWidth, this.displayHeight);
                }
                this.adjustBloodVisionShaders(this.getBloodVisionProgress((float)event.getPartialTick()));
            } else {
                MixinHooks.enforcingGlowing_bloodVision = true;
            }
        }
        if (((Boolean)VampirismConfig.SERVER.preventRenderingDebugBoundingBoxes.get()).booleanValue()) {
            Minecraft.getInstance().getEntityRenderDispatcher().setRenderHitBoxes(false);
        }
        if (event.getCamera().getEntity() instanceof LivingEntity && ((LivingEntity)event.getCamera().getEntity()).isSleeping()) {
            ((LivingEntity)event.getCamera().getEntity()).getSleepingPos().map(pos -> event.getCamera().getEntity().level().getBlockState(pos)).filter(blockState -> blockState.getBlock() instanceof CoffinBlock).ifPresent(blockState -> {
                if (((Boolean)blockState.getValue((Property)CoffinBlock.VERTICAL)).booleanValue()) {
                    ((CameraAccessor)event.getCamera()).invoke_move(0.2f, -0.2f, 0.0f);
                } else {
                    ((CameraAccessor)event.getCamera()).invoke_move(0.0f, -0.2f, 0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        if (this.mc.level == null || this.mc.player == null || !this.mc.player.isAlive()) {
            return;
        }
        this.lastBloodVisionTicks = this.bloodVisionTicks;
        VampirePlayer vampire = VampirePlayer.get((Player)this.mc.player);
        if (vampire.getSpecialAttributes().blood_vision && !((Boolean)VampirismConfig.CLIENT.disableBloodVisionRendering.get()).booleanValue() && !vampire.isGettingSundamage((LevelAccessor)this.mc.player.level())) {
            if (this.bloodVisionTicks < 80) {
                ++this.bloodVisionTicks;
            }
        } else {
            if (this.bloodVisionTicks > 0) {
                this.bloodVisionTicks -= 2;
            }
            if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                this.bloodVisionTicks = 0;
            }
        }
        if (this.mc.player.tickCount % 10 == 0) {
            if (!this.mc.player.isSpectator() && (((Boolean)VampirismConfig.CLIENT.renderVampireForestFog.get()).booleanValue() || ((Boolean)VampirismConfig.SERVER.enforceRenderForestFog.get()).booleanValue()) && (Helper.isEntityInArtificalVampireFogArea((Entity)this.mc.player) || Helper.isEntityInVampireBiome((Entity)this.mc.player))) {
                this.insideFog = true;
                this.vampireBiomeFogDistanceMultiplier = vampire.getLevel() > 0 ? 2.0f : 1.0f;
                this.vampireBiomeFogDistanceMultiplier += vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.VISTA.get()) ? ((Double)VampirismConfig.BALANCE.vrVistaMod.get()).floatValue() : 0.0f;
                this.vampireBiomeFogDistanceMultiplier = VampirismEventFactory.fireVampireFogEvent(this.vampireBiomeFogDistanceMultiplier);
            } else {
                this.insideFog = false;
            }
        }
        if (this.insideFog) {
            if (this.vampireBiomeTicks < 60) {
                ++this.vampireBiomeTicks;
            }
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
    }

    @SubscribeEvent
    public void onRenderFog(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ViewportEvent.RenderFog event) {
        if (this.vampireBiomeTicks == 0) {
            return;
        }
        float f = 60.0f / (float)this.vampireBiomeTicks / 1.5f;
        f *= this.vampireBiomeFogDistanceMultiplier;
        event.setNearPlaneDistance(switch (event.getMode()) {
            default -> throw new MatchException(null, null);
            case FogRenderer.FogMode.FOG_TERRAIN -> Math.min(event.getFarPlaneDistance() * 0.75f, 6.0f * f);
            case FogRenderer.FogMode.FOG_SKY -> 0.0f;
        });
        event.setFarPlaneDistance(Math.min(event.getFarPlaneDistance(), 50.0f * f));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onRenderHand(@NotNull RenderHandEvent event) {
        if (this.mc.player != null && this.mc.player.isAlive() && VampirismPlayerAttributes.get((Player)this.mc.player).getVampSpecial().bat) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderLivingEvent.Post<?, ?> event) {
        if (!this.isInsideBloodVisionRendering && this.shouldRenderBloodVision() && !this.reducedBloodVision) {
            LivingEntity entity = event.getEntity();
            boolean flag = !(entity instanceof Player) || VampirismPlayerAttributes.get((Player)((Player)entity)).getHuntSpecial().fullHunterCoat == null;
            double dist = this.mc.player.distanceToSqr((Entity)entity);
            if (dist > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistanceSq.get()).intValue()) {
                flag = false;
            }
            if (flag) {
                Optional<ExtendedCreature> opt;
                Optional<ExtendedCreature> optional = opt = entity instanceof PathfinderMob && entity.isAlive() ? ExtendedCreature.getSafe((Entity)entity) : Optional.empty();
                int color = opt.map(creature -> creature.getBlood() > 0 && !creature.hasPoisonousBlood()).orElse(false) != false ? 0xFF0000 : (VampirismPlayerAttributes.get((Player)this.mc.player).getVampSpecial().blood_vision_garlic && (opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) != false || entity instanceof IHunterMob) ? 524039 : 0xA0A0A0);
                EntityRenderDispatcher renderManager = this.mc.getEntityRenderDispatcher();
                OutlineBuffer bloodVisionBuffer = this.bloodVisionBuffer.getBuffer(event.getMultiBufferSource());
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getBloodVisionProgress(event.getPartialTick()));
                bloodVisionBuffer.setColor(r, g, b, alpha);
                float f = Mth.lerp((float)event.getPartialTick(), (float)entity.yRotO, (float)entity.getYRot());
                this.isInsideBloodVisionRendering = true;
                EntityRenderer entityrenderer = renderManager.getRenderer((Entity)entity);
                entityrenderer.render((Entity)entity, f, event.getPartialTick(), event.getPoseStack(), (MultiBufferSource)bloodVisionBuffer, event.getPackedLight());
                this.mc.getMainRenderTarget().bindWrite(false);
                this.isInsideBloodVisionRendering = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && VampirismPlayerAttributes.get((Player)entity).getHuntSpecial().isDisguised()) {
            IItemWithTier.TIER hunterCoatTier;
            double dist;
            double d = dist = this.mc.player == null ? 0.0 : entity.distanceToSqr((Entity)this.mc.player);
            if (dist > 64.0) {
                event.setCanceled(true);
            } else if (dist > 16.0 && ((hunterCoatTier = VampirismPlayerAttributes.get((Player)((Player)entity)).getHuntSpecial().fullHunterCoat) == IItemWithTier.TIER.ENHANCED || hunterCoatTier == IItemWithTier.TIER.ULTIMATE)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderFirstPersonHand(@NotNull RenderHandEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && event.getHand() == player.getUsedItemHand() && event.getItemStack().getItem() instanceof CrucifixItem) {
            HumanoidArm humanoidarm = event.getHand() == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
            int i = humanoidarm == HumanoidArm.RIGHT ? 1 : -1;
            event.getPoseStack().translate((double)((float)(-i) * 0.56f), -0.0, (double)-0.2f);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        VampirePlayerSpecialAttributes vAtt = VampirismPlayerAttributes.get(player).getVampSpecial();
        if (vAtt.isDBNO) {
            event.getPoseStack().translate(1.2, 0.0, 0.0);
            PlayerModel m = (PlayerModel)event.getRenderer().getModel();
            m.rightArm.visible = false;
            m.rightSleeve.visible = false;
            m.leftArm.visible = false;
            m.leftSleeve.visible = false;
            m.rightLeg.visible = false;
            m.leftLeg.visible = false;
            m.rightPants.visible = false;
            m.leftPants.visible = false;
        } else if (player.getSleepingPos().map(pos -> player.level().getBlockState(pos)).map(state -> state.getBlock() instanceof CoffinBlock).orElse(false).booleanValue()) {
            event.getPoseStack().scale(0.8f, 0.95f, 0.8f);
        } else if (player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && player.getUseItem().getItem() instanceof CrucifixItem) {
            boolean main = player.getUsedItemHand() == InteractionHand.MAIN_HAND;
            if ((main ? player.getMainArm() : player.getMainArm().getOpposite()) == HumanoidArm.RIGHT) {
                ((PlayerModel)event.getRenderer().getModel()).rightArmPose = HumanoidModel.ArmPose.BLOCK;
            } else {
                ((PlayerModel)event.getRenderer().getModel()).leftArmPose = HumanoidModel.ArmPose.BLOCK;
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(@NotNull RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            MixinHooks.enforcingGlowing_bloodVision = false;
            if (this.mc.level == null) {
                return;
            }
            if (this.shouldRenderBloodVision() && !this.reducedBloodVision) {
                this.blurShader.process(this.mc.getTimer().getGameTimeDeltaTicks());
                this.mc.getMainRenderTarget().bindWrite(false);
            }
        }
    }

    public void endBloodVisionBatch() {
        if (this.shouldRenderBloodVision() && !this.reducedBloodVision && this.bloodVisionBuffer != null) {
            this.bloodVisionBuffer.endOutlineBatch();
        }
    }

    public void onResourceManagerReload(@NotNull ResourceManager resourceManager) {
        this.reMakeBloodVisionShader();
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        this.bloodVisionTicks = 0;
        this.vampireBiomeTicks = 0;
        this.insideFog = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderPlayerPreHigh(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        VampirePlayerSpecialAttributes vAtt = VampirismPlayerAttributes.get(player).getVampSpecial();
        if (vAtt.invisible) {
            event.setCanceled(true);
        } else if (vAtt.bat) {
            event.setCanceled(true);
            Bat bat = (Bat)player.getData(ModAttachments.VAMPIRE_BAT);
            float partialTicks = event.getPartialTick();
            bat.yBodyRotO = player.yBodyRotO;
            bat.yBodyRot = player.yBodyRot;
            bat.tickCount = player.tickCount;
            bat.setXRot(player.getXRot());
            bat.setYRot(player.getYRot());
            bat.yHeadRot = player.yHeadRot;
            bat.yRotO = player.yRotO;
            bat.xRotO = player.xRotO;
            bat.yHeadRotO = player.yHeadRotO;
            bat.setInvisible(player.isInvisible());
            double d0 = Mth.lerp((double)partialTicks, (double)bat.xOld, (double)bat.getX());
            double d1 = Mth.lerp((double)partialTicks, (double)bat.yOld, (double)bat.getY());
            double d2 = Mth.lerp((double)partialTicks, (double)bat.zOld, (double)bat.getZ());
            float f = Mth.lerp((float)partialTicks, (float)bat.yRotO, (float)bat.getYRot());
            EntityRenderer renderer = this.mc.getEntityRenderDispatcher().getRenderer((Entity)bat);
            renderer.render((Entity)bat, f, partialTicks, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    public boolean shouldRenderBloodVision() {
        return this.bloodVisionTicks > 0 && this.blurShader != null && this.mc.player != null;
    }

    private void adjustBloodVisionShaders(float progress) {
        if (this.blit0 == null || this.blur1 == null || this.blur2 == null) {
            return;
        }
        progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
        this.blit0.getEffect().safeGetUniform("ColorModulate").set(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
        this.blur1.getEffect().safeGetUniform("Radius").set((float)Math.round(15.0f * progress));
        this.blur2.getEffect().safeGetUniform("Radius").set((float)Math.round(15.0f * progress));
    }

    private float getBloodVisionProgress(float partialTicks) {
        return ((float)this.bloodVisionTicks + (float)(this.bloodVisionTicks - this.lastBloodVisionTicks) * partialTicks) / 80.0f;
    }

    private void reMakeBloodVisionShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = VResourceLocation.mod("shaders/blank.json");
        try {
            this.blurShader = new PostChain(this.mc.getTextureManager(), (ResourceProvider)this.mc.getResourceManager(), this.mc.getMainRenderTarget(), resourcelocationBlur);
            RenderTarget swap = this.blurShader.getTempTarget("swap");
            this.blit0 = this.blurShader.addPass("blit", swap, this.mc.getMainRenderTarget(), false);
            this.blur1 = this.blurShader.addPass("box_blur", this.mc.getMainRenderTarget(), swap, false);
            this.blur1.getEffect().safeGetUniform("BlurDir").set(1.0f, 0.0f);
            this.blur2 = this.blurShader.addPass("box_blur", swap, this.mc.getMainRenderTarget(), false);
            this.blur2.getEffect().safeGetUniform("BlurDir").set(0.0f, 1.0f);
            this.blurShader.resize(this.mc.getWindow().getWidth(), this.mc.getWindow().getHeight());
        }
        catch (Exception e) {
            this.LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.resize(width, height);
        }
    }

    private static class Buffers {
        private final Map<MultiBufferSource, OutlineBuffer> buffers = new HashMap<MultiBufferSource, OutlineBuffer>();

        private Buffers() {
        }

        public OutlineBuffer getBuffer(MultiBufferSource original) {
            return this.buffers.computeIfAbsent(original, OutlineBuffer::new);
        }

        public void endOutlineBatch() {
            this.buffers.values().forEach(OutlineBuffer::endOutlineBatch);
            this.buffers.clear();
        }
    }

    private static class OutlineBuffer
    implements MultiBufferSource {
        private final MultiBufferSource bufferSource;
        private final MultiBufferSource.BufferSource outlineBufferSource = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        private int teamR = 255;
        private int teamG = 255;
        private int teamB = 255;
        private int teamA = 255;

        public OutlineBuffer(MultiBufferSource pBufferSource) {
            this.bufferSource = pBufferSource;
        }

        public VertexConsumer getBuffer(RenderType pRenderType) {
            if (pRenderType.isOutline()) {
                VertexConsumer vertexconsumer2 = this.outlineBufferSource.getBuffer(pRenderType);
                return new EntityOutlineGenerator(vertexconsumer2, this.teamR, this.teamG, this.teamB, this.teamA);
            }
            VertexConsumer vertexconsumer = this.bufferSource.getBuffer(pRenderType);
            Optional optional = pRenderType.outline();
            if (optional.isPresent()) {
                VertexConsumer vertexconsumer1 = this.outlineBufferSource.getBuffer((RenderType)optional.get());
                EntityOutlineGenerator outlinebuffersource$entityoutlinegenerator = new EntityOutlineGenerator(vertexconsumer1, this.teamR, this.teamG, this.teamB, this.teamA);
                return VertexMultiConsumer.create((VertexConsumer)outlinebuffersource$entityoutlinegenerator, (VertexConsumer)vertexconsumer);
            }
            return vertexconsumer;
        }

        public void setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
            this.teamR = pRed;
            this.teamG = pGreen;
            this.teamB = pBlue;
            this.teamA = pAlpha;
        }

        public void endOutlineBatch() {
            this.outlineBufferSource.endBatch();
        }

        @OnlyIn(value=Dist.CLIENT)
        record EntityOutlineGenerator(VertexConsumer delegate, int color) implements VertexConsumer
        {
            public EntityOutlineGenerator(VertexConsumer p_109943_, int p_109944_, int p_109945_, int p_109946_, int p_109947_) {
                this(p_109943_, FastColor.ARGB32.color((int)p_109947_, (int)p_109944_, (int)p_109945_, (int)p_109946_));
            }

            public VertexConsumer addVertex(float p_350357_, float p_350369_, float p_350557_) {
                this.delegate.addVertex(p_350357_, p_350369_, p_350557_).setColor(this.color);
                return this;
            }

            public VertexConsumer setColor(int p_350802_, int p_351011_, int p_350273_, int p_351040_) {
                return this;
            }

            public VertexConsumer setUv(float p_350507_, float p_350470_) {
                this.delegate.setUv(p_350507_, p_350470_);
                return this;
            }

            public VertexConsumer setUv1(int p_350412_, int p_350568_) {
                return this;
            }

            public VertexConsumer setUv2(int p_350636_, int p_351006_) {
                return this;
            }

            public VertexConsumer setNormal(float p_350484_, float p_350765_, float p_350737_) {
                return this;
            }
        }
    }
}

