/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.hunter.IAdvancedHunter;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.BasicHunterModel;
import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.client.renderer.entity.layers.CloakLayer;
import de.teamlapen.vampirism.client.renderer.entity.layers.PlayerFaceOverlayLayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedHunterRenderer
extends DualBipedRenderer<AdvancedHunterEntity, BasicHunterModel<AdvancedHunterEntity>> {
    private static final ResourceLocation textureCloak = VResourceLocation.mod("textures/entity/hunter_cloak.png");
    private static final PlayerSkin fallback = new PlayerSkin(VResourceLocation.mod("textures/entity/hunter_base1.png"), null, null, null, PlayerSkin.Model.WIDE, false);
    @NotNull
    private final PlayerSkin[] textures;

    public AdvancedHunterRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, new BasicHunterModel(context.bakeLayer(ModEntitiesRender.HUNTER), false), new BasicHunterModel(context.bakeLayer(ModEntitiesRender.HUNTER), true), 0.5f);
        this.addLayer(new CloakLayer(this, textureCloak, IAdvancedHunter::hasCloak));
        this.addLayer((RenderLayer)new DualBipedRenderer.ArmorLayer((DualBipedRenderer)this, (RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_SLIM_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_SLIM_OUTER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        if (((Boolean)VampirismConfig.CLIENT.renderAdvancedMobPlayerFaces.get()).booleanValue()) {
            this.addLayer(new PlayerFaceOverlayLayer<AdvancedHunterEntity, BasicHunterModel<AdvancedHunterEntity>>(this));
            ((BasicHunterModel)this.getModel()).head.visible = false;
            ((BasicHunterModel)this.getModel()).hat.visible = false;
            this.textures = this.gatherTextures("textures/entity/hunter", true);
        } else {
            this.textures = new PlayerSkin[0];
        }
    }

    @Override
    protected PlayerSkin determineTextureAndModel(@NotNull AdvancedHunterEntity entity) {
        if (this.textures.length == 0) {
            return fallback;
        }
        return this.textures[entity.getBodyTexture() % this.textures.length];
    }

    protected void renderNameTag(@NotNull AdvancedHunterEntity entityIn, @NotNull Component displayNameIn, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, float partialTicks) {
        double dist = this.entityRenderDispatcher.distanceToSqr((Entity)entityIn);
        if (dist <= 256.0) {
            super.renderNameTag((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn, (float)packedLightIn);
        }
    }
}

