/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.renderer.entity.layers.AdvancedVampireEyeLayer;
import de.teamlapen.vampirism.client.renderer.entity.layers.AdvancedVampireFangLayer;
import de.teamlapen.vampirism.client.renderer.entity.layers.PlayerFaceOverlayLayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.util.TextureComparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class AdvancedVampireRenderer
extends HumanoidMobRenderer<AdvancedVampireEntity, HumanoidModel<AdvancedVampireEntity>> {
    private final ResourceLocation texture = VResourceLocation.mod("textures/entity/advanced_vampire.png");
    private final ResourceLocation @NotNull [] textures;

    public AdvancedVampireRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED), false), 0.5f);
        if (((Boolean)VampirismConfig.CLIENT.renderAdvancedMobPlayerFaces.get()).booleanValue()) {
            this.addLayer(new PlayerFaceOverlayLayer<AdvancedVampireEntity, HumanoidModel<AdvancedVampireEntity>>(this));
            this.addLayer(new AdvancedVampireEyeLayer((RenderLayerParent<AdvancedVampireEntity, HumanoidModel<AdvancedVampireEntity>>)this));
            this.addLayer(new AdvancedVampireFangLayer((RenderLayerParent<AdvancedVampireEntity, HumanoidModel<AdvancedVampireEntity>>)this));
        }
        this.textures = (ResourceLocation[])Minecraft.getInstance().getResourceManager().listResources("textures/entity/vampire", s -> s.getPath().endsWith(".png")).keySet().stream().filter(r -> "vampirism".equals(r.getNamespace())).sorted(TextureComparator.alphaNumericComparator()).toArray(ResourceLocation[]::new);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull AdvancedVampireEntity entity) {
        if (this.textures.length == 0) {
            return this.texture;
        }
        return this.textures[entity.getBodyTexture() & this.textures.length];
    }

    protected void renderNameTag(@NotNull AdvancedVampireEntity entityIn, @NotNull Component displayNameIn, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, float partialTicks) {
        double dist = this.entityRenderDispatcher.distanceToSqr((Entity)entityIn);
        if (dist <= 256.0) {
            super.renderNameTag((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn, (float)packedLightIn);
        }
    }
}

