/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.command.arguments.FactionArgument;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LevelCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"level").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"faction", (ArgumentType)FactionArgument.playableFactions()).executes(context -> LevelCommand.setLevel((CommandContext<CommandSourceStack>)context, FactionArgument.getPlayableFaction((CommandContext<CommandSourceStack>)context, "faction"), 1, Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(((RequiredArgumentBuilder)Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LevelCommand.setLevel((CommandContext<CommandSourceStack>)context, FactionArgument.getPlayableFaction((CommandContext<CommandSourceStack>)context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> LevelCommand.setLevel((CommandContext<CommandSourceStack>)context, FactionArgument.getPlayableFaction((CommandContext<CommandSourceStack>)context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), EntityArgument.getPlayers((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"none").executes(context -> LevelCommand.leaveFaction(Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> LevelCommand.leaveFaction(EntityArgument.getPlayers((CommandContext)context, (String)"player")))));
    }

    private static int setLevel(@NotNull CommandContext<CommandSourceStack> context, @NotNull IPlayableFaction<?> faction, int level, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler h = FactionPlayerHandler.get((Player)player);
            if (level == 0 && !h.canLeaveFaction()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.vampirism.base.level.cant_leave", (Object[])new Object[]{players.size() > 1 ? player.getDisplayName() : "Player", h.getCurrentFaction().getName()}));
                continue;
            }
            int finalLevel = Math.min(level, faction.getHighestReachableLevel());
            if (h.setFactionAndLevel(faction, finalLevel)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.vampirism.base.level.successful", (Object[])new Object[]{player.getName(), faction.getName(), finalLevel}), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)(players.size() > 1 ? Component.translatable((String)"command.vampirism.failed_to_execute.players", (Object[])new Object[]{player.getDisplayName()}) : Component.translatable((String)"command.vampirism.failed_to_execute")));
        }
        return 0;
    }

    private static int leaveFaction(@NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler.get((Player)player).setFactionAndLevel(null, 0);
        }
        return 0;
    }
}

