/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.reloadlistener;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.teamlapen.vampirism.data.ServerSkillTreeData;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeConfiguration;
import de.teamlapen.vampirism.entity.player.skills.SkillTreeHolder;
import io.netty.handler.codec.DecoderException;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class SkillTreeReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String DIRECTORY = "vampirism/configured_skill_tree";
    private Map<ResourceLocation, SkillTreeHolder> configuration = ImmutableMap.of();

    public SkillTreeReloadListener() {
        super(GSON, DIRECTORY);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistryOps registryOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.getRegistryLookup());
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)new SkillTreeHolder(entry.getKey(), (SkillTreeConfiguration)((Pair)SkillTreeConfiguration.CODEC.decode((DynamicOps)registryOps, (Object)entry.getValue()).getOrThrow(DecoderException::new)).getFirst()));
        }
        this.configuration = builder.build();
        ServerSkillTreeData.init(this.configuration.values().stream().map(SkillTreeHolder::configuration).toList());
    }

    public Collection<SkillTreeHolder> getTrees() {
        return this.configuration.values();
    }
}

