/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.IEntityWithHome;
import de.teamlapen.vampirism.api.entity.IVampirismEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.config.ServerConfig;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.world.LevelFog;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VampirismEntity
extends PathfinderMob
implements IEntityWithHome,
IVampirismEntity {
    @NotNull
    private final Goal moveTowardsRestriction = new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0);
    protected boolean hasArms = true;
    protected boolean peaceful = false;
    protected boolean saveHome = false;
    @Nullable
    private AABB home;
    private boolean moveTowardsRestrictionAdded = false;
    private int moveTowardsRestrictionPrio = -1;
    private int randomTickDivider;
    private boolean doImobConversion = false;

    public static boolean spawnPredicateVampireFog(@NotNull LevelAccessor world, @NotNull BlockPos blockPos) {
        return world.getBiome(blockPos).is(ModTags.Biomes.IS_VAMPIRE_BIOME) || world instanceof Level && LevelFog.getOpt((Level)world).map(vh -> vh.isInsideArtificialVampireFogArea(blockPos)).orElse(false) != false;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return PathfinderMob.createLivingAttributes().add(Attributes.ATTACK_DAMAGE).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK);
    }

    public VampirismEntity(@NotNull EntityType<? extends VampirismEntity> type, @NotNull Level world) {
        super(type, world);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.saveHome && this.home != null) {
            int[] h = new int[]{(int)this.home.minX, (int)this.home.minY, (int)this.home.minZ, (int)this.home.maxX, (int)this.home.maxY, (int)this.home.maxZ};
            nbt.putIntArray("home", h);
            if (this.moveTowardsRestrictionAdded && this.moveTowardsRestrictionPrio > -1) {
                nbt.putInt("homeMovePrio", this.moveTowardsRestrictionPrio);
            }
        }
    }

    @Override
    @Nullable
    public AABB getHome() {
        return this.home;
    }

    public void aiStep() {
        if (this.hasArms) {
            this.updateSwingTime();
        }
        super.aiStep();
    }

    public boolean checkSpawnRules(@NotNull LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        return (this.peaceful || worldIn.getDifficulty() != Difficulty.PEACEFUL) && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    @Override
    public boolean isWithinHomeDistance(double x, double y, double z) {
        if (this.home != null) {
            return this.home.contains(new Vec3(x, y, z));
        }
        return true;
    }

    @Override
    @NotNull
    public BlockPos getHomePosition() {
        return this.getRestrictCenter();
    }

    public boolean isWithinRestriction() {
        return this.isWithinHomeDistance(this.getX(), this.getY(), this.getZ());
    }

    public boolean isWithinRestriction(@NotNull BlockPos pos) {
        return this.isWithinHomeDistance(pos);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("home")) {
            this.saveHome = true;
            int[] h = nbt.getIntArray("home");
            this.setHome(new AABB((double)h[0], (double)h[1], (double)h[2], (double)h[3], (double)h[4], (double)h[5]));
            if (nbt.contains("homeMovePrio")) {
                this.setMoveTowardsRestriction(nbt.getInt("moveHomePrio"), true);
            }
        }
    }

    public void restrictTo(@NotNull BlockPos pos, int distance) {
        this.setHomeArea(pos, distance);
    }

    @Override
    public void setHome(@Nullable AABB home) {
        this.home = home;
        if (home != null) {
            int posX = (int)(home.minX + (home.maxX - home.minX) / 2.0);
            int posY = (int)(home.minY + (home.maxY - home.minY) / 2.0);
            int posZ = (int)(home.minZ + (home.maxZ - home.minZ) / 2.0);
            super.restrictTo(new BlockPos(posX, posY, posZ), (int)home.getSize());
        } else {
            super.restrictTo(new BlockPos(0, 0, 0), -1);
        }
    }

    @Override
    public void setHomeArea(@NotNull BlockPos pos, int r) {
        this.setHome(new AABB(Vec3.atLowerCornerOf((Vec3i)pos.offset(-r, -r, -r)), Vec3.atLowerCornerWithOffset((Vec3i)pos.offset(r, r, r), (double)1.0, (double)1.0, (double)1.0)));
    }

    public void tick() {
        super.tick();
        this.checkImobConversion();
        if (!this.level().isClientSide && !this.peaceful && this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.random.nextInt(50);
            this.onRandomTick();
        }
    }

    protected void disableImobConversion() {
        this.doImobConversion = false;
    }

    protected void disableMoveTowardsRestriction() {
        if (this.moveTowardsRestrictionAdded) {
            this.goalSelector.removeGoal(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
    }

    protected void enableImobConversion() {
        if (!(this instanceof IFactionEntity)) {
            throw new IllegalStateException("Can only do IMob conversion for IFactionEntity");
        }
        this.doImobConversion = true;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.HOSTILE_DEATH;
    }

    @NotNull
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.HOSTILE_SMALL_FALL, SoundEvents.HOSTILE_BIG_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.HOSTILE_HURT;
    }

    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return this.getType();
    }

    @NotNull
    protected SoundEvent getSwimSound() {
        return SoundEvents.HOSTILE_SWIM;
    }

    @NotNull
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    protected boolean isLowLightLevel(@NotNull LevelAccessor iWorld) {
        BlockPos blockpos = new BlockPos((int)this.getX(), (int)this.getBoundingBox().minY, (int)this.getZ());
        if (iWorld.getBrightness(LightLayer.SKY, blockpos) > this.random.nextInt(32)) {
            return false;
        }
        if (iWorld.getBrightness(LightLayer.BLOCK, blockpos) > 0) {
            return false;
        }
        int i = iWorld.getMaxLocalRawBrightness(blockpos);
        if (iWorld instanceof Level && ((Level)iWorld).isThundering()) {
            i = iWorld.getMaxLocalRawBrightness(blockpos);
        }
        return i <= this.random.nextInt(8);
    }

    protected void onRandomTick() {
    }

    protected void setDontDropEquipment() {
        Arrays.fill(this.armorDropChances, 0.0f);
        Arrays.fill(this.handDropChances, 0.0f);
    }

    protected void setMoveTowardsRestriction(int prio, boolean active) {
        if (this.moveTowardsRestrictionAdded) {
            if (active && this.moveTowardsRestrictionPrio == prio) {
                return;
            }
            this.goalSelector.removeGoal(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
        if (active) {
            this.goalSelector.addGoal(prio, this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = true;
            this.moveTowardsRestrictionPrio = prio;
        }
    }

    public boolean shouldDropExperience() {
        return true;
    }

    protected void teleportAway() {
        this.setInvisible(true);
        ModParticles.spawnParticlesServer(this.level(), new GenericParticleOptions(VResourceLocation.mc("effect_6"), 10, 657930, 0.6f), this.getX(), this.getY(), this.getZ(), 20, 1.0, 1.0, 1.0, 0.0);
        this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        this.discard();
    }

    private void checkImobConversion() {
        if (this.doImobConversion && !this.level().isClientSide && this.tickCount % 256 == 0 && this.isAlive()) {
            boolean current = this instanceof Enemy;
            boolean convert = false;
            ServerConfig.IMobOptions opt = (ServerConfig.IMobOptions)((Object)VampirismConfig.SERVER.entityIMob.get());
            if (ServerLifecycleHooks.getCurrentServer().isDedicatedServer()) {
                convert = opt == ServerConfig.IMobOptions.ALWAYS_IMOB != current;
            } else if (opt == ServerConfig.IMobOptions.SMART) {
                Player player = VampirismMod.proxy.getClientPlayer();
                if (player != null && player.isAlive()) {
                    IPlayableFaction<?> f = VampirismPlayerAttributes.get((Player)player).faction;
                    IFaction<?> thisFaction = ((IFactionEntity)((Object)this)).getFaction();
                    boolean hostile = f == null ? thisFaction.isHostileTowardsNeutral() : !thisFaction.equals(f);
                    convert = hostile != current;
                }
            } else {
                boolean bl = convert = opt == ServerConfig.IMobOptions.ALWAYS_IMOB != current;
            }
            if (convert) {
                EntityType<?> t = this.getIMobTypeOpt(!current);
                Helper.createEntity(t, this.level()).ifPresent(newEntity -> {
                    CompoundTag nbt = new CompoundTag();
                    this.saveWithoutId(nbt);
                    newEntity.load(nbt);
                    newEntity.setUUID(Mth.createInsecureUUID((RandomSource)this.random));
                    assert (newEntity instanceof LivingEntity);
                    UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)newEntity);
                });
            }
        }
    }

    public boolean canBeLeashed() {
        return false;
    }
}

