/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.storage.ISyncable;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.converted.CurableConvertedCreature;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.mixin.accessor.EntityAccessor;
import de.teamlapen.vampirism.mixin.accessor.WalkAnimationStateAccessor;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertedCreatureEntity<T extends PathfinderMob>
extends VampireBaseEntity
implements CurableConvertedCreature<T, ConvertedCreatureEntity<T>>,
ISyncable {
    private static final String NBT_KEY = "converted";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.defineId(ConvertedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.defineId(ConvertedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private boolean entityChanged = false;
    public Optional<T> entityCreature = Optional.empty();
    private boolean canDespawn = false;
    private final CurableConvertedCreature.Data<T> convertibleData = new CurableConvertedCreature.Data();

    public static boolean spawnPredicate(EntityType<? extends ConvertedCreatureEntity<?>> entityType, @NotNull LevelAccessor iWorld, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return (iWorld.getBlockState(blockPos.below()).getBlock() == Blocks.GRASS_BLOCK || iWorld.getBlockState(blockPos.below()).is(ModTags.Blocks.CURSED_EARTH)) && iWorld.getRawBrightness(blockPos, 0) > 8;
    }

    public ConvertedCreatureEntity(EntityType<? extends ConvertedCreatureEntity<?>> type, Level world) {
        super(type, world, false);
        this.enableImobConversion();
        this.xpReward = 2;
    }

    @Override
    public String nbtKey() {
        return NBT_KEY;
    }

    @Override
    public CurableConvertedCreature.Data<T> data() {
        return this.convertibleData;
    }

    @Override
    public void handleEntityEventSuper(byte id) {
        super.handleEntityEvent(id);
    }

    @Override
    public InteractionResult mobInteractSuper(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.mobInteract(player, hand);
    }

    @Override
    public boolean hurtSuper(DamageSource damageSource, float amount) {
        return super.hurt(damageSource, amount);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.writeOldEntityToNBT(pCompound);
        pCompound.putBoolean("converter_canDespawn", this.canDespawn);
        this.addAdditionalSaveDataC(pCompound);
    }

    @Override
    public void aiStep() {
        this.entityCreature.ifPresent(creature -> this.aiStepC(creature.getType()));
        super.aiStep();
    }

    @Override
    public void die(@NotNull DamageSource pDamageSource) {
        super.die(pDamageSource);
        this.dieC(pDamageSource);
    }

    @NotNull
    public Component getTypeName() {
        return this.entityCreature.map(creature -> this.getNameC(() -> ((EntityType)creature.getType()).getDescription())).orElseGet(() -> super.getTypeName());
    }

    @Override
    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        return this.hurtC(pSource, pAmount);
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        return this.mobInteractC(pPlayer, pHand);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.registerConvertingData(builder);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.registerGoalsC();
    }

    @Override
    protected void tickDeath() {
        super.tickDeath();
        this.tickDeathC();
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.entityCreature.isEmpty()) {
            LOGGER.debug("Setting dead, since creature is null");
            this.discard();
        }
        super.tick();
        this.tickC();
    }

    @Override
    public T cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<T> newType) {
        return (T)this.entityCreature.map(creature -> {
            creature.revive();
            return creature;
        }).orElseGet(() -> CurableConvertedCreature.super.cureEntity(world, entity, newType));
    }

    public void baseTick() {
        super.baseTick();
        this.entityCreature.ifPresent(entityCreature -> {
            entityCreature.copyPosition((Entity)this);
            entityCreature.zo = this.zo;
            entityCreature.yo = this.yo;
            entityCreature.xo = this.xo;
            entityCreature.yHeadRot = this.yHeadRot;
            entityCreature.xRotO = this.xRotO;
            entityCreature.yRotO = this.yRotO;
            entityCreature.yHeadRotO = this.yHeadRotO;
            entityCreature.setDeltaMovement(this.getDeltaMovement());
            entityCreature.xOld = this.xOld;
            entityCreature.yOld = this.yOld;
            entityCreature.zOld = this.zOld;
            entityCreature.hurtTime = this.hurtTime;
            entityCreature.hurtDuration = this.hurtDuration;
            entityCreature.attackAnim = this.attackAnim;
            entityCreature.oAttackAnim = this.oAttackAnim;
            ((WalkAnimationStateAccessor)entityCreature.walkAnimation).setSpeed(((WalkAnimationStateAccessor)this.walkAnimation).getSpeed());
            ((WalkAnimationStateAccessor)entityCreature.walkAnimation).setSpeedOld(((WalkAnimationStateAccessor)this.walkAnimation).getSpeedOld());
            ((WalkAnimationStateAccessor)entityCreature.walkAnimation).setPosition(((WalkAnimationStateAccessor)this.walkAnimation).getPosition());
            entityCreature.yBodyRot = this.yBodyRot;
            entityCreature.yBodyRotO = this.yBodyRotO;
            entityCreature.deathTime = this.deathTime;
        });
        if (this.entityChanged) {
            this.updateEntityAttributes();
            this.entityChanged = false;
        }
    }

    @Override
    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    public EntityDataAccessor<String> getSourceEntityDataParam() {
        return OVERLAY_TEXTURE;
    }

    public Optional<T> getOldCreature() {
        return this.entityCreature;
    }

    @Override
    public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        if (nbt.contains("entity_old", 10)) {
            this.setEntityCreature(EntityType.create((CompoundTag)nbt.getCompound("entity_old"), (Level)this.getCommandSenderWorld()).orElse(null));
        }
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readAdditionalSaveDataC(nbt);
        if (nbt.contains("entity_old")) {
            this.setEntityCreature(EntityType.create((CompoundTag)nbt.getCompound("entity_old"), (Level)this.level()).orElse(null));
            if (this.entityCreature.isEmpty()) {
                LOGGER.warn("Failed to create old entity {}. Maybe the entity does not exist anymore", (Object)nbt.getCompound("entity_old"));
            }
        } else {
            LOGGER.warn("Saved entity did not have a old entity");
        }
        if (nbt.contains("converted_canDespawn")) {
            this.canDespawn = nbt.getBoolean("converted_canDespawn");
        }
        if (nbt.contains("ConversionTime", 99) && nbt.getInt("ConversionTime") > -1) {
            this.startConverting(nbt.hasUUID("ConversionPlayer") ? nbt.getUUID("ConversionPlayer") : null, nbt.getInt("ConversionTime"), this);
        }
        if (!nbt.contains("source_entity")) {
            this.getSourceEntityDataParamOpt().ifPresent(p -> this.getOldCreature().ifPresent(old -> this.getRepresentingEntity().getEntityData().set(p, (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)old.getType()).toString())));
        }
    }

    public void playAmbientSound() {
        this.entityCreature.ifPresent(Mob::playAmbientSound);
    }

    public void refreshDimensions() {
        super.refreshDimensions();
        ((EntityAccessor)((Object)this)).setEyeHeight(this.entityCreature.map(Entity::getEyeHeight).orElse(Float.valueOf(0.5f)).floatValue());
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return super.removeWhenFarAway(distanceToClosestPlayer) && this.canDespawn;
    }

    public void setCanDespawn() {
        this.canDespawn = true;
    }

    public void setEntityCreature(@Nullable T creature) {
        PathfinderMob old = this.entityCreature.orElse(null);
        if (!Objects.equals(old, creature)) {
            this.entityCreature = Optional.ofNullable(creature);
            this.entityChanged = true;
            ((EntityAccessor)((Object)this)).setDimensions(this.entityCreature.map(s -> s.dimensions).orElseGet(() -> EntityDimensions.fixed((float)0.5f, (float)0.5f)));
        }
        if (this.entityCreature.isPresent() && this.getConvertedHandler() == null) {
            LOGGER.warn("Cannot find converting handler for converted creature {} ({})", (Object)this, this.entityCreature);
            this.entityCreature = Optional.empty();
        }
    }

    @Nullable
    public ItemEntity spawnAtLocation(@NotNull ItemStack stack, float offsetY) {
        ItemStack actualDrop = stack;
        if (stack.is(ItemTags.MEAT)) {
            actualDrop = new ItemStack((ItemLike)Items.ROTTEN_FLESH, stack.getCount());
        }
        return super.spawnAtLocation(actualDrop, offsetY);
    }

    @NotNull
    public String toString() {
        return "[" + super.toString() + " representing " + String.valueOf(this.entityCreature) + "]";
    }

    @Override
    @NotNull
    public CompoundTag serializeUpdateNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.writeOldEntityToNBT(tag);
        return tag;
    }

    @Nullable
    protected IConvertingHandler<?> getConvertedHandler() {
        if (this.entityCreature.isEmpty()) {
            return null;
        }
        IConvertingHandler handler = this.entityCreature.map(s -> VampirismAPI.entityRegistry().getConverterEntry((PathfinderMob)s)).map(s -> s.converter().createHandler(s.overlay().orElse(null))).orElse(null);
        if (handler == null) {
            LOGGER.warn("No converting handler found for {}", this.entityCreature.get());
        }
        return handler;
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.CONVERTED_CREATURE_IMOB.get() : (EntityType)ModEntities.CONVERTED_CREATURE.get();
    }

    @NotNull
    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.entityCreature.map(Mob::getLootTable).orElseGet(() -> super.getDefaultLootTable());
    }

    protected void updateEntityAttributes() {
        IConvertingHandler<?> convertedHandler = this.getConvertedHandler();
        if (convertedHandler != null) {
            convertedHandler.updateEntityAttributes(this);
        }
    }

    private void writeOldEntityToNBT(@NotNull CompoundTag nbt) {
        this.entityCreature.ifPresent(creature -> {
            try {
                CompoundTag entity = new CompoundTag();
                creature.revive();
                creature.save(entity);
                creature.discard();
                nbt.put("entity_old", (Tag)entity);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to write old entity (%s) to NBT. If this happens more often please report this to the mod author.", creature), (Throwable)e);
                this.setEntityCreature(null);
            }
        });
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    public float calculateFireDamage(float amount) {
        return CurableConvertedCreature.super.calculateFireDamage(amount);
    }

    public static class IMob<T extends PathfinderMob>
    extends ConvertedCreatureEntity<T>
    implements Enemy {
        public IMob(EntityType<? extends IMob<?>> type, Level world) {
            super((EntityType<? extends ConvertedCreatureEntity<?>>)type, world);
        }
    }
}

