/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.base.Predicate;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionPredicate
implements Predicate<LivingEntity> {
    @NotNull
    private final IFaction<?> thisFaction;
    private final boolean player;
    private final boolean nonPlayer;
    private final boolean neutralPlayer;
    private final boolean ignoreDisguise;
    @Nullable
    private final IFaction<?> otherFaction;

    protected FactionPredicate(@NotNull IFaction<?> thisFaction, boolean player, boolean nonPlayer, boolean neutralPlayer, boolean ignoreDisguise, @Nullable IFaction<?> otherFaction) {
        this.thisFaction = thisFaction;
        this.player = player;
        this.nonPlayer = nonPlayer;
        this.neutralPlayer = neutralPlayer;
        this.otherFaction = otherFaction;
        this.ignoreDisguise = ignoreDisguise;
    }

    protected FactionPredicate(@NotNull Faction<?> thisFaction, boolean player, boolean nonPlayer, boolean neutralPlayer, boolean ignoreDisguise) {
        this(thisFaction, player, nonPlayer, neutralPlayer, ignoreDisguise, null);
    }

    public boolean apply(@Nullable LivingEntity input) {
        if (input == null) {
            return false;
        }
        if (this.nonPlayer && input instanceof IFactionEntity) {
            IFaction<?> other = ((IFactionEntity)input).getFaction();
            return !this.thisFaction.equals(other) && (this.otherFaction == null || this.otherFaction.equals(other));
        }
        if (this.player && input instanceof Player && input.isAlive()) {
            return FactionPlayerHandler.getCurrentFactionPlayer((Player)input).map(fp -> {
                IFaction<?> f = this.ignoreDisguise ? fp.getFaction() : fp.getDisguisedAs();
                return (f != null || this.thisFaction.isHostileTowardsNeutral() && this.neutralPlayer) && !this.thisFaction.equals(f) && (this.otherFaction == null || this.otherFaction.equals(f));
            }).orElse(this.neutralPlayer);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return "PredicateFaction{thisFaction=" + String.valueOf(this.thisFaction) + ", player=" + this.player + ", nonPlayer=" + this.nonPlayer + ", neutralPlayer=" + this.neutralPlayer + ", otherFaction=" + String.valueOf(this.otherFaction) + "}";
    }
}

