/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.entity.CaptureEntityEntry;
import de.teamlapen.vampirism.api.entity.ITaskMasterEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillage;
import de.teamlapen.vampirism.entity.factions.FactionVillageBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionVillage
implements IFactionVillage {
    private final Holder<MobEffect> badOmenEffect;
    private final Function<HolderLookup.Provider, ItemStack> bannerStack;
    @NotNull
    private final ImmutableList<CaptureEntityEntry<?>> captureEntities;
    private final Supplier<VillagerProfession> factionVillageProfession;
    private final Class<? extends Mob> guardSuperClass;
    private final Supplier<EntityType<? extends ITaskMasterEntity>> taskMasterEntity;
    private final Supplier<? extends Block> fragileTotem;
    private final Supplier<? extends Block> craftedTotem;

    public FactionVillage(@NotNull FactionVillageBuilder builder) {
        this.badOmenEffect = builder.badOmenEffect;
        this.bannerStack = builder.bannerStack;
        this.captureEntities = ImmutableList.copyOf(builder.captureEntities);
        this.factionVillageProfession = builder.factionVillageProfession;
        this.guardSuperClass = builder.guardSuperClass;
        this.taskMasterEntity = builder.taskMasterEntity;
        this.fragileTotem = builder.fragileTotem;
        this.craftedTotem = builder.craftedTotem;
    }

    @Override
    @Nullable
    public MobEffect getBadOmenEffect() {
        return this.badOmenEffect != null ? (MobEffect)this.badOmenEffect.value() : null;
    }

    @Override
    @Nullable
    public Holder<MobEffect> badOmenEffect() {
        return this.badOmenEffect;
    }

    @Override
    @NotNull
    public ItemStack getBanner(HolderLookup.Provider provider) {
        return this.bannerStack.apply(provider).copy();
    }

    @Override
    public List<CaptureEntityEntry<?>> getCaptureEntries() {
        return this.captureEntities;
    }

    @Override
    @NotNull
    public VillagerProfession getFactionVillageProfession() {
        return this.factionVillageProfession.get();
    }

    @Override
    @NotNull
    public Class<? extends Mob> getGuardSuperClass() {
        return this.guardSuperClass;
    }

    @Override
    @Nullable
    public EntityType<? extends ITaskMasterEntity> getTaskMasterEntity() {
        return this.taskMasterEntity.get();
    }

    @Override
    @NotNull
    public Block getTotemTopBlock(boolean crafted) {
        return crafted ? this.craftedTotem.get() : this.fragileTotem.get();
    }

    @Override
    public boolean isBanner(@NotNull ItemStack stack, HolderLookup.Provider provider) {
        return ItemStack.matches((ItemStack)this.bannerStack.apply(provider), (ItemStack)stack);
    }
}

