/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.advancements.critereon.VampireActionCriterionTrigger;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class HunterBaseEntity
extends VampirismEntity
implements IHunterMob,
Npc {
    protected final int MOVE_TO_RESTRICT_PRIO = 3;

    public static boolean spawnPredicateHunter(@NotNull EntityType<? extends HunterBaseEntity> entityType, @NotNull LevelAccessor world, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return world.getDifficulty() != Difficulty.PEACEFUL && Mob.checkMobSpawnRules(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    public HunterBaseEntity(EntityType<? extends HunterBaseEntity> type, Level world, @Deprecated(forRemoval=true) boolean countAsMonster) {
        super(type, world);
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        if (cause.getEntity() instanceof ServerPlayer && Helper.isVampire((Player)cause.getEntity()) && this.getEffect((Holder)ModEffects.FREEZE) != null) {
            ((VampireActionCriterionTrigger)((Object)ModAdvancements.TRIGGER_VAMPIRE_ACTION.get())).trigger((ServerPlayer)cause.getEntity(), VampireActionCriterionTrigger.Action.KILL_FROZEN_HUNTER);
        }
    }

    public void makeCampHunter(@NotNull BlockPos pos) {
        super.setHome(new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate(10.0));
        this.setMoveTowardsRestriction(3, true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    protected boolean tryCureSanguinare(@NotNull Player entity) {
        if (!this.level().isClientSide && entity.hasEffect(ModEffects.SANGUINARE)) {
            entity.removeEffect(ModEffects.SANGUINARE);
            entity.sendSystemMessage((Component)Component.translatable((String)"text.vampirism.hunter.cured_sanguinare"));
            return true;
        }
        return false;
    }

    public static enum HatType {
        NONE(null),
        HAT_0((Supplier<? extends Item>)ModItems.HUNTER_HAT_HEAD_0),
        HAT_1((Supplier<? extends Item>)ModItems.HUNTER_HAT_HEAD_1);

        private final Supplier<? extends Item> headItem;

        private HatType(Supplier<? extends Item> headItem) {
            this.headItem = headItem;
        }

        public ItemStack getHeadItem() {
            if (this.headItem == null) {
                return ItemStack.EMPTY;
            }
            return this.headItem.get().getDefaultInstance();
        }

        @NotNull
        public static HatType get(String value) {
            try {
                return HatType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return NONE;
            }
        }
    }

    public static enum EquipmentType {
        NONE(null, null),
        STAKE((Supplier<? extends Item>)ModItems.STAKE, null),
        AXE((Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL, null),
        AXE_STAKE((Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL, (Supplier<? extends Item>)ModItems.STAKE),
        CROSSBOW((Supplier<? extends Item>)ModItems.BASIC_CROSSBOW, null),
        DOUBLE_AXE((Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL, (Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL);

        private final Supplier<? extends Item> mainHand;
        private final Supplier<? extends Item> offHand;

        private EquipmentType(Supplier<? extends Item> mainHand, Supplier<? extends Item> offHand) {
            this.mainHand = mainHand;
            this.offHand = offHand;
        }

        public ItemStack getMainHand() {
            if (this.mainHand == null) {
                return ItemStack.EMPTY;
            }
            return this.mainHand.get().getDefaultInstance();
        }

        public ItemStack getOffHand() {
            if (this.offHand == null) {
                return ItemStack.EMPTY;
            }
            return this.offHand.get().getDefaultInstance();
        }

        @NotNull
        public static EquipmentType get(String value) {
            try {
                return EquipmentType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return NONE;
            }
        }
    }
}

