/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.refinements;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Refinement
implements IRefinement {
    @Nullable
    private final Holder<Attribute> attribute;
    @Nullable
    private final BiFunction<ResourceLocation, Double, AttributeModifier> modifier;
    private final double baseValue;
    private boolean detrimental = false;
    private MutableComponent description;

    public Refinement(@Nullable Holder<Attribute> attribute, double baseValue, @Nullable BiFunction<ResourceLocation, Double, AttributeModifier> modifier) {
        this.attribute = attribute;
        this.modifier = modifier;
        this.baseValue = baseValue;
    }

    public Refinement() {
        this.attribute = null;
        this.modifier = null;
        this.baseValue = 0.0;
    }

    @Override
    public AttributeModifier createAttributeModifier(double value) {
        return this.modifier == null ? null : this.modifier.apply(ModRegistries.REFINEMENTS.getKey((Object)this), value);
    }

    @Override
    @Nullable
    public Holder<Attribute> getAttribute() {
        return this.attribute;
    }

    @Override
    @NotNull
    public Component getDescription() {
        if (this.description == null) {
            this.description = Component.translatable((String)("refinement." + RegUtil.id(this).getNamespace() + "." + RegUtil.id(this).getPath() + ".desc"));
            if (this.detrimental) {
                this.description.withStyle(ChatFormatting.RED);
            }
        }
        return this.description;
    }

    @Override
    public double getModifierValue() {
        return this.baseValue;
    }

    @NotNull
    public Refinement setDetrimental() {
        this.detrimental = true;
        return this;
    }
}

