/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.CodecUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskInstance
implements ITaskInstance {
    public static final Codec<TaskInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CodecUtil.UUID.fieldOf("taskGiver").forGetter(t -> t.taskGiver), (App)ResourceKey.codec(VampirismRegistries.Keys.TASK).fieldOf("task").forGetter(t -> t.task), (App)CodecUtil.UUID.fieldOf("instanceId").forGetter(t -> t.instanceId), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).fieldOf("stats").forGetter(t -> t.stats), (App)ITaskRewardInstance.CODEC.fieldOf("reward").forGetter(t -> t.reward), (App)Codec.LONG.fieldOf("taskDuration").forGetter(t -> t.taskDuration), (App)Codec.BOOL.fieldOf("accepted").forGetter(t -> t.accepted), (App)Codec.LONG.fieldOf("taskTimer").forGetter(t -> t.taskTimeStamp)).apply((Applicative)inst, TaskInstance::new));
    @NotNull
    private final UUID taskGiver;
    @NotNull
    private final ResourceKey<Task> task;
    @NotNull
    private final UUID instanceId;
    @NotNull
    private final Map<ResourceLocation, Integer> stats;
    @NotNull
    private final ITaskRewardInstance reward;
    private final long taskDuration;
    private boolean accepted;
    private long taskTimeStamp;
    private boolean completed;

    public TaskInstance(@NotNull Holder.Reference<Task> task, @NotNull UUID taskGiver, @NotNull IFactionPlayer<?> player, long taskDuration) {
        this.task = task.key();
        this.taskGiver = taskGiver;
        this.instanceId = UUID.randomUUID();
        this.stats = new HashMap<ResourceLocation, Integer>();
        this.taskTimeStamp = -1L;
        this.taskDuration = taskDuration;
        this.reward = ((Task)task.value()).getReward().createInstance(player);
    }

    private TaskInstance(@NotNull UUID taskGiver, @NotNull ResourceKey<Task> task, @NotNull UUID instanceId, @NotNull Map<ResourceLocation, Integer> stats, @NotNull ITaskRewardInstance taskRewardInstance, long taskDuration, boolean accepted, long taskTimeStamp) {
        this.taskGiver = taskGiver;
        this.task = task;
        this.stats = new HashMap<ResourceLocation, Integer>(stats);
        this.accepted = accepted;
        this.taskTimeStamp = taskTimeStamp;
        this.instanceId = instanceId;
        this.reward = taskRewardInstance;
        this.taskDuration = taskDuration;
    }

    @Override
    public void aboardTask() {
        this.accepted = false;
        this.stats.clear();
        this.taskTimeStamp = -1L;
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        buffer.writeJsonWithCodec(CODEC, (Object)this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance instance = (TaskInstance)o;
        return this.accepted == instance.accepted && this.taskTimeStamp == instance.taskTimeStamp && Objects.equal((Object)this.taskGiver, (Object)instance.taskGiver) && Objects.equal((Object)this.instanceId, (Object)instance.instanceId) && Objects.equal(this.task, instance.task) && Objects.equal(this.stats, instance.stats);
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.instanceId;
    }

    @Override
    @NotNull
    public ITaskRewardInstance getReward() {
        return this.reward;
    }

    @Override
    @NotNull
    public Map<ResourceLocation, Integer> getStats() {
        return this.stats;
    }

    @Override
    @NotNull
    public ResourceKey<Task> getTask() {
        return this.task;
    }

    @Override
    @NotNull
    public UUID getTaskBoard() {
        return this.taskGiver;
    }

    @Override
    public long getTaskDuration() {
        return this.taskDuration;
    }

    @Override
    public long getTaskTimeStamp() {
        return this.taskTimeStamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskGiver, this.task, this.instanceId});
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isUnique(Registry<Task> registry) {
        return registry.getHolder(this.task).map(s -> s.is(ModTags.Tasks.IS_UNIQUE)).orElse(false);
    }

    @Override
    public void startTask(long timestamp) {
        this.taskTimeStamp = timestamp;
        this.accepted = true;
    }
}

