/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class DummyBittenAnimalEntity
extends Mob {
    public static boolean spawnPredicate(EntityType<? extends DummyBittenAnimalEntity> entityType, @NotNull LevelAccessor iWorld, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return iWorld.getBlockState(blockPos.below()).getBlock() == Blocks.GRASS_BLOCK || iWorld.getBlockState(blockPos.below()).is(ModTags.Blocks.CURSED_EARTH);
    }

    public DummyBittenAnimalEntity(@NotNull EntityType<? extends DummyBittenAnimalEntity> type, @NotNull Level world) {
        super(type, world);
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount > 4 && !this.getCommandSenderWorld().isClientSide) {
            Pig entity;
            int rand = this.random.nextInt(3);
            switch (rand) {
                case 0: {
                    Pig pig = (Pig)EntityType.PIG.create(this.level());
                    break;
                }
                case 1: {
                    Pig pig = (Sheep)EntityType.SHEEP.create(this.level());
                    break;
                }
                default: {
                    Pig pig = entity = (Cow)EntityType.COW.create(this.level());
                }
            }
            if (entity == null) {
                return;
            }
            entity.copyPosition((Entity)this);
            ExtendedCreature.getSafe((Entity)entity).ifPresent(e -> {
                IConvertedCreature<?> c;
                if (e.canBecomeVampire() && (c = e.makeVampire()) instanceof ConvertedCreatureEntity) {
                    ((ConvertedCreatureEntity)c).setCanDespawn();
                }
            });
            this.discard();
        }
    }
}

