/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.entity.vampire.IVampireBaron;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.ai.goals.AttackRangedDarkBloodGoal;
import de.teamlapen.vampirism.entity.ai.goals.FleeGarlicVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireBaronEntity
extends VampireBaseEntity
implements IVampireBaron {
    public static final int MAX_LEVEL = 4;
    private static final Logger LOGGER = LogManager.getLogger(VampireBaronEntity.class);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.defineId(VampireBaronEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.defineId(VampireBaronEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LADY = SynchedEntityData.defineId(VampireBaronEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int ENRAGED_TRANSITION_TIME = 15;
    private int attackDecisionCounter = 0;
    private boolean rangedAttack = false;
    private boolean prevAttacking = false;
    private int followingEntities = 0;
    private int enragedTransitionTime = 0;

    public static boolean spawnPredicateBaron(@NotNull EntityType<? extends VampireBaronEntity> entityType, @NotNull LevelAccessor world, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return world.getBiome(blockPos).is(ModTags.Biomes.IS_VAMPIRE_BIOME) && world.getDifficulty() != net.minecraft.world.Difficulty.PEACEFUL && Mob.checkMobSpawnRules(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return VampireBaseEntity.getAttributeBuilder().add(Attributes.MAX_HEALTH, BalanceMobProps.mobProps.VAMPIRE_BARON_MAX_HEALTH).add(Attributes.ATTACK_DAMAGE, BalanceMobProps.mobProps.VAMPIRE_BARON_ATTACK_DAMAGE).add(Attributes.MOVEMENT_SPEED, BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED).add(Attributes.FOLLOW_RANGE, 5.0);
    }

    public VampireBaronEntity(EntityType<? extends VampireBaronEntity> type, Level world) {
        super(type, world, true);
        this.garlicResist = EnumStrength.MEDIUM;
        this.hasArms = true;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("level", this.getEntityLevel());
        nbt.putBoolean("lady", this.isLady());
    }

    @Override
    public void aiStep() {
        if (!this.prevAttacking && this.getTarget() != null) {
            this.prevAttacking = true;
            this.updateEntityAttributes(true);
        }
        if (this.prevAttacking && this.getTarget() == null) {
            this.prevAttacking = false;
            this.rangedAttack = false;
            this.attackDecisionCounter = 0;
            this.updateEntityAttributes(false);
        }
        if (!this.level().isClientSide && this.isGettingSundamage((LevelAccessor)this.level())) {
            this.teleportAway();
        }
        if (!this.level().isClientSide && this.getTarget() != null && this.tickCount % 128 == 0) {
            if (this.rangedAttack) {
                if (this.random.nextInt(2) == 0 && this.navigation.createPath((Entity)this.getTarget(), 0) != null) {
                    this.rangedAttack = false;
                }
            } else if (this.attackDecisionCounter > 4 || this.random.nextInt(6) == 0) {
                this.rangedAttack = true;
                this.attackDecisionCounter = 0;
            }
            if (this.getEntityLevel() > 3 && this.random.nextInt(9) == 0) {
                this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 60));
            }
        }
        if (this.level().isClientSide()) {
            if (this.isEnraged() && this.enragedTransitionTime < 15) {
                ++this.enragedTransitionTime;
            } else if (!this.isEnraged() && this.enragedTransitionTime > 0) {
                --this.enragedTransitionTime;
            }
        }
        super.aiStep();
    }

    @Override
    public boolean checkSpawnRules(@NotNull LevelAccessor worldIn, @NotNull MobSpawnType spawnReasonIn) {
        int i = Mth.floor((double)this.getBoundingBox().minY);
        if (i < 60) {
            return false;
        }
        BlockPos blockpos = new BlockPos((int)this.getX(), (int)this.getBoundingBox().minY, (int)this.getZ());
        return worldIn.getBlockState(blockpos.below()).is(ModTags.Blocks.CURSED_EARTH) && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    @Override
    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    @Override
    public boolean doHurtTarget(@NotNull Entity entity) {
        boolean flag = super.doHurtTarget(entity);
        if (flag && entity instanceof LivingEntity) {
            float tm = 1.0f;
            int mr = 1;
            if (entity instanceof Player) {
                float pld = (float)(this.getEntityLevel() + 1) - (float)VampirismPlayerAttributes.get((Player)((Player)entity)).vampireLevel / 3.0f;
                tm = pld + 1.0f;
                int n = pld < 1.5f ? 1 : (mr = pld < 3.0f ? 2 : 3);
                if (VampirismPlayerAttributes.get((Player)((Player)entity)).getHuntSpecial().fullHunterCoat != null) {
                    tm *= 0.5f;
                }
            }
            if (entity instanceof VampireBaronEntity) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, 5));
            }
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.WEAKNESS, (int)(200.0f * tm), this.random.nextInt(mr)));
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, (int)(100.0f * tm), this.random.nextInt(mr)));
            this.attackDecisionCounter = 0;
        }
        return flag;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        this.getEntityData().set(LADY, (Object)this.getRandom().nextBoolean());
        if (reason == MobSpawnType.COMMAND || reason == MobSpawnType.SPAWN_EGG) {
            // empty if block
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public float getEnragedProgress() {
        return (float)this.enragedTransitionTime / 15.0f;
    }

    @Override
    public int getFollowingCount() {
        return this.followingEntities;
    }

    @Override
    public int getEntityLevel() {
        return (Integer)this.getEntityData().get(LEVEL);
    }

    @Override
    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.getEntityData().set(LEVEL, (Object)level);
            this.updateEntityAttributes(false);
            float hp = this.getHealth() / this.getMaxHealth();
            this.setHealth(this.getMaxHealth() * hp);
            this.setCustomName((Component)this.getTypeName().plainCopy().append((Component)Component.translatable((String)"entity.vampirism.vampire_baron.level", (Object[])new Object[]{level + 1})));
        } else {
            this.setCustomName(null);
        }
    }

    public int getMaxHeadXRot() {
        return 5;
    }

    @Override
    public int getMaxFollowerCount() {
        return (int)((float)(BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * this.getEntityLevel()) / (float)this.getMaxEntityLevel() * 2.0f);
    }

    public int getMaxHeadYRot() {
        return 5;
    }

    @Override
    public int getMaxEntityLevel() {
        return 4;
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public int getDimensionChangingDelay() {
        return 500;
    }

    @Override
    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float amount) {
        ++this.attackDecisionCounter;
        return super.hurt(damageSource, amount);
    }

    public boolean isEnraged() {
        return (Boolean)this.getEntityData().get(ENRAGED);
    }

    public boolean isLady() {
        return (Boolean)this.getEntityData().get(LADY);
    }

    public void setLady(boolean lady) {
        this.getEntityData().set(LADY, (Object)lady);
    }

    public boolean killedEntity(@NotNull ServerLevel world, @NotNull LivingEntity entity) {
        boolean result = super.killedEntity(world, entity);
        if (entity instanceof VampireBaronEntity) {
            this.setHealth(this.getMaxHealth());
        }
        return result;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setEntityLevel(nbt.contains("level") ? Mth.clamp((int)nbt.getInt("level"), (int)0, (int)4) : -1);
        this.getEntityData().set(LADY, (Object)nbt.getBoolean("lady"));
    }

    public void setTarget(@Nullable LivingEntity target) {
        super.setTarget(target);
        this.getEntityData().set(ENRAGED, (Object)(target != null ? 1 : 0));
    }

    public boolean shouldShowName() {
        return true;
    }

    @Override
    public int suggestEntityLevel(@NotNull Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel() / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int max = Math.round(((float)d.maxPercLevel() / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int min = Math.round(((float)d.minPercLevel() / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        return switch (this.random.nextInt(7)) {
            case 0 -> min;
            case 1 -> max + 1;
            case 2 -> avg;
            case 3 -> avg + 1;
            case 4, 5 -> this.random.nextInt(5);
            default -> this.random.nextInt(max - min + 2) + min;
        };
    }

    @Override
    protected float calculateFireDamage(float amount) {
        double d = amount;
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return (float)(d * 3.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEVEL, (Object)-1);
        builder.define(ENRAGED, (Object)false);
        builder.define(LADY, (Object)false);
    }

    protected int getBaseExperienceReward() {
        this.xpReward = 20 + 5 * this.getEntityLevel();
        return super.getBaseExperienceReward();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new FleeGarlicVampireGoal(this, (double)0.9f, false));
        this.goalSelector.addGoal(5, (Goal)new BaronAIAttackMelee(this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new BaronAIAttackRanged(this, 60, 64, 6.0f, 4.0f));
        this.goalSelector.addGoal(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 0.6, (double)0.7f, input -> input != null && !this.isLowerLevel((LivingEntity)input)));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.2));
        this.goalSelector.addGoal(9, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::isLowerLevel));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, VampireBaronEntity.class, true, false));
    }

    protected void updateEntityAttributes(boolean aggressive) {
        if (aggressive) {
            this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(20.0);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow((BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL - 1.0) / 5.0 + 1.0, this.getEntityLevel()));
        } else {
            this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(5.0);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(BalanceMobProps.mobProps.VAMPIRE_BARON_MOVEMENT_SPEED * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getEntityLevel()) / 3.0);
        }
        float healthPercentage = this.getHealth() / this.getMaxHealth();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(BalanceMobProps.mobProps.VAMPIRE_BARON_MAX_HEALTH * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getEntityLevel()));
        this.setHealth(healthPercentage * this.getMaxHealth());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(BalanceMobProps.mobProps.VAMPIRE_BARON_ATTACK_DAMAGE * Math.pow(BalanceMobProps.mobProps.VAMPIRE_BARON_IMPROVEMENT_PER_LEVEL, this.getEntityLevel()));
    }

    private boolean isLowerLevel(LivingEntity player) {
        if (player instanceof Player) {
            int playerLevel = FactionPlayerHandler.get((Player)player).getCurrentLevel();
            return (float)(playerLevel - 8) / 2.0f - (float)this.getEntityLevel() <= 0.0f;
        }
        return false;
    }

    protected boolean canRide(@NotNull Entity pVehicle) {
        return false;
    }

    private class BaronAIAttackMelee
    extends MeleeAttackGoal {
        BaronAIAttackMelee(PathfinderMob creature, double speedIn) {
            super(creature, speedIn, false);
        }

        public boolean canContinueToUse() {
            return !VampireBaronEntity.this.rangedAttack && super.canContinueToUse();
        }

        public boolean canUse() {
            return !VampireBaronEntity.this.rangedAttack && super.canUse();
        }
    }

    private class BaronAIAttackRanged
    extends AttackRangedDarkBloodGoal {
        BaronAIAttackRanged(VampireBaronEntity entity, int cooldown, int maxDistance, float damage, float indirectDamage) {
            super(entity, cooldown, maxDistance, damage, indirectDamage);
        }

        @Override
        public boolean canUse() {
            return VampireBaronEntity.this.getTarget() != null && (VampireBaronEntity.this.rangedAttack || !VampireBaronEntity.this.isPathFinding());
        }
    }
}

