/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.fluids;

import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import java.util.function.Consumer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BloodHelper {
    private static final Logger LOGGER = LogManager.getLogger(BloodHelper.class);

    public static boolean canStoreBlood(@NotNull ItemStack stack) {
        return BloodHelper.fill(stack, 1000, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    @NotNull
    public static ItemStack getGlassBottleInHotbar(@NotNull Inventory inventory) {
        int hotbarSize = Inventory.getSelectionSize();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty() || !itemStack.getItem().equals(Items.GLASS_BOTTLE)) continue;
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public static int getBlood(@NotNull ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getAmount).orElse(0);
    }

    public static int getBlood(@NotNull IFluidHandler cap) {
        FluidStack stack = cap.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
        return stack.getAmount();
    }

    public static int drain(@NotNull ItemStack stack, int amount, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull IFluidHandler.FluidAction action, boolean exact, @NotNull Consumer<ItemStack> updateContainer) {
        if (exact && action.execute() && BloodHelper.drain(stack, amount, IFluidHandler.FluidAction.SIMULATE, false, updateContainer) != amount) {
            return 0;
        }
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            FluidStack fluidStack = handler.drain(amount, action);
            updateContainer.accept(handler.getContainer());
            return fluidStack.getAmount();
        }).orElse(0);
    }

    public static int fill(@NotNull ItemStack stack, int amount, IFluidHandler.FluidAction action) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> handler.fill(new FluidStack((Fluid)ModFluids.BLOOD.get(), amount), action)).orElse(0);
    }

    public static int fillBloodIntoInventory(@NotNull Player player, int amt) {
        ItemStack container;
        ItemStack glass;
        if (amt <= 0) {
            return 0;
        }
        ItemStack stack = ItemStack.EMPTY;
        int hotbarSize = Inventory.getSelectionSize();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack stack1 = player.getInventory().getItem(i);
            if (stack1.isEmpty() || BloodHelper.fill(stack1, amt, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
            stack = stack1;
            break;
        }
        if (!stack.isEmpty()) {
            int filled = BloodHelper.fill(stack, amt, IFluidHandler.FluidAction.EXECUTE);
            if (filled > 0) {
                if (filled < amt) {
                    return BloodHelper.fillBloodIntoInventory(player, amt - filled);
                }
                return 0;
            }
            LOGGER.warn("Could not execute bottle fill even though simulation was successful. Item: {} Amount: {}", (Object)stack, (Object)amt);
        }
        if (!(glass = BloodHelper.getGlassBottleInHotbar(player.getInventory())).isEmpty() && ((Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get()).booleanValue()) {
            ItemStack bloodBottle = new ItemStack((ItemLike)ModItems.BLOOD_BOTTLE.get(), 1);
            int filled = BloodHelper.fill(bloodBottle, amt, IFluidHandler.FluidAction.EXECUTE);
            if (filled == 0) {
                LOGGER.warn("Failed to fill blood bottle with blood");
            }
            glass.shrink(1);
            if (glass.isEmpty()) {
                player.getInventory().removeItem(glass);
            }
            if (!player.getInventory().add(bloodBottle)) {
                player.drop(bloodBottle, false);
            }
            return BloodHelper.fillBloodIntoInventory(player, amt - filled);
        }
        if (BloodHelper.hasFeedingAdapterInHotbar(player.getInventory()) && !(container = BloodHelper.getBloodContainerInInventory(player.getInventory(), false, true)).isEmpty()) {
            FluidStack content = BloodContainerBlock.getFluidFromItemStack(container);
            int filled = Math.min(amt, 12600 - content.getAmount());
            content.setAmount(content.getAmount() + filled);
            BloodContainerBlock.writeFluidToItemStack(container, content);
            return BloodHelper.fillBloodIntoInventory(player, amt - filled);
        }
        return amt;
    }

    public static boolean hasFeedingAdapterInHotbar(@NotNull Inventory inventory) {
        int hotbarSize = Inventory.getSelectionSize();
        for (int i = 0; i < hotbarSize; ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty() || !itemStack.getItem().equals(ModItems.FEEDING_ADAPTER.get())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ItemStack getBloodContainerInInventory(@NotNull Inventory inventory, boolean allowFull, boolean allowEmpty) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            FluidStack content = BloodContainerBlock.getFluidFromItemStack(stack);
            if (!content.getFluid().isSame((Fluid)ModFluids.BLOOD.get()) || !allowFull && content.getAmount() >= 12600 || !allowEmpty && content.getAmount() <= 0) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

