/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModMenus;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionTableMenu
extends InventoryContainerMenu {
    private final boolean extended;
    @NotNull
    private final ContainerData syncedProperties;

    public PotionTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPos, @NotNull Container inventory, boolean extended, @Nullable ContainerData syncedProperties) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModMenus.EXTENDED_POTION_TABLE.get()), id, playerInventory, worldPos, inventory, PotionTableMenu.getSelectorInfos(playerInventory.player.level(), extended));
        assert (inventory.getContainerSize() >= (extended ? 8 : 6));
        this.syncedProperties = syncedProperties == null ? new SimpleContainerData(2) : syncedProperties;
        this.addPlayerSlots(playerInventory);
        this.addDataSlots(this.syncedProperties);
        this.extended = extended;
    }

    public int getBrewTime() {
        return this.syncedProperties.get(0);
    }

    public int getFuelTime() {
        return this.syncedProperties.get(1);
    }

    public boolean isExtendedTable() {
        return this.extended;
    }

    @Override
    protected boolean isSlotEnabled(int id) {
        return id <= 5 || this.isExtendedTable();
    }

    private static InventoryContainerMenu.SelectorInfo[] getSelectorInfos(Level level, boolean extended) {
        InventoryContainerMenu.SelectorInfo[] SELECTOR_INFOS = new InventoryContainerMenu.SelectorInfo[6];
        InventoryContainerMenu.SelectorInfo[] SELECTOR_INFOS_EXTENDED = new InventoryContainerMenu.SelectorInfo[8];
        SELECTOR_INFOS[0] = SELECTOR_INFOS_EXTENDED[0] = new InventoryContainerMenu.SelectorInfo((Predicate<ItemStack>)Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER}), 23, 14);
        SELECTOR_INFOS[1] = SELECTOR_INFOS_EXTENDED[1] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidExtraIngredient((ItemStack)stack), 101, 16);
        SELECTOR_INFOS[2] = SELECTOR_INFOS_EXTENDED[2] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidIngredient(level.potionBrewing(), (ItemStack)stack), 126, 8);
        SELECTOR_INFOS[3] = SELECTOR_INFOS_EXTENDED[3] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput(level.potionBrewing(), (ItemStack)stack), 148, 59);
        SELECTOR_INFOS[4] = SELECTOR_INFOS_EXTENDED[4] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput(level.potionBrewing(), (ItemStack)stack), 126, 59);
        SELECTOR_INFOS[5] = SELECTOR_INFOS_EXTENDED[5] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput(level.potionBrewing(), (ItemStack)stack), 104, 59);
        SELECTOR_INFOS_EXTENDED[6] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput(level.potionBrewing(), (ItemStack)stack), 82, 59);
        SELECTOR_INFOS_EXTENDED[7] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput(level.potionBrewing(), (ItemStack)stack), 60, 59);
        return extended ? SELECTOR_INFOS_EXTENDED : SELECTOR_INFOS;
    }

    public static class Factory
    implements IContainerFactory<PotionTableMenu> {
        @NotNull
        public PotionTableMenu create(int windowId, @NotNull Inventory inv, @Nullable RegistryFriendlyByteBuf data) {
            if (data == null) {
                return new PotionTableMenu(windowId, inv, ContainerLevelAccess.NULL, (Container)new SimpleContainer(6), false, null);
            }
            boolean extraSlots = data.readBoolean();
            return new PotionTableMenu(windowId, inv, ContainerLevelAccess.NULL, (Container)new SimpleContainer(extraSlots ? 8 : 6), extraSlots, null);
        }
    }
}

