/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.blocks.AlchemicalFireBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemicalFireItem
extends Item {
    public AlchemicalFireItem() {
        super(new Item.Properties());
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.vampirism.item_alchemical_fire.desc1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.vampirism.item_alchemical_fire.desc2").withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos().relative(ctx.getClickedFace());
        if (ctx.getPlayer() != null && !ctx.getPlayer().mayUseItemAt(pos, ctx.getClickedFace(), ctx.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        if (ctx.getLevel().isEmptyBlock(pos)) {
            ctx.getLevel().playSound(ctx.getPlayer(), pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, ctx.getPlayer().getRandom().nextFloat() * 0.4f + 0.8f);
            ctx.getLevel().setBlock(pos, (BlockState)((AlchemicalFireBlock)((Object)ModBlocks.ALCHEMICAL_FIRE.get())).defaultBlockState().setValue((Property)AlchemicalFireBlock.AGE, (Comparable)Integer.valueOf(15)), 11);
            ctx.getItemInHand().shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

