/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.refinements.RefinementSet;
import de.teamlapen.vampirism.items.component.EffectiveRefinementSet;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefinementItem
extends Item
implements IRefinementItem,
ModDisplayItemGenerator.CreativeTabItemProvider {
    public static final int MAX_DAMAGE = 500;
    private static final RandomSource RANDOM = RandomSource.create();
    private final IRefinementItem.AccessorySlotType type;

    @NotNull
    public static ItemStack getRandomRefinementItem(@NotNull IPlayableFaction<?> faction) {
        ItemStack stack;
        List sets = RegUtil.values(ModRegistries.REFINEMENT_SETS).stream().filter(set -> set.getFaction() == faction).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return ItemStack.EMPTY;
        }
        IRefinementSet s = WeightedRandom.getRandomItem((RandomSource)RANDOM, sets).map(WeightedEntry.Wrapper::data).orElseGet(() -> (IRefinementSet)((WeightedEntry.Wrapper)sets.getFirst()).data());
        IRefinementItem.AccessorySlotType t = s.getSlotType().orElseGet(() -> switch (RANDOM.nextInt(3)) {
            case 0 -> IRefinementItem.AccessorySlotType.OBI_BELT;
            case 1 -> IRefinementItem.AccessorySlotType.RING;
            default -> IRefinementItem.AccessorySlotType.AMULET;
        });
        IRefinementItem i = (IRefinementItem)faction.getRefinementItem(t);
        if (i.applyRefinementSet(stack = new ItemStack((ItemLike)i), s)) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    public static IRefinementSet getRandomRefinementForItem(@Nullable IFaction<?> faction, @NotNull IRefinementItem stack) {
        List sets = RegUtil.values(ModRegistries.REFINEMENT_SETS).stream().filter(set -> faction == null || set.getFaction() == faction).filter(set -> set.getSlotType().map(s -> s == stack.getSlotType()).orElse(true)).map(a -> ((RefinementSet)a).getWeightedRandom()).collect(Collectors.toList());
        if (sets.isEmpty()) {
            return null;
        }
        return WeightedRandom.getRandomItem((RandomSource)RANDOM, sets).map(WeightedEntry.Wrapper::data).orElse(null);
    }

    public RefinementItem(@NotNull Item.Properties properties, IRefinementItem.AccessorySlotType type) {
        super(properties.durability(500).setNoRepair());
        this.type = type;
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 10;
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        IRefinementSet set = this.getRefinementSet(stack);
        if (set != null) {
            set.getRefinements().stream().map(Supplier::get).forEach(refinement -> tooltip.add((Component)Component.literal((String)" - ").append(refinement.getDescription()).withStyle(ChatFormatting.GRAY)));
        }
    }

    @Override
    public boolean applyRefinementSet(@NotNull ItemStack stack, @NotNull IRefinementSet set) {
        if (set.getSlotType().map(t -> t == this.type).orElse(true).booleanValue()) {
            stack.set(ModDataComponents.REFINEMENT_SET, (Object)new EffectiveRefinementSet(set));
            return true;
        }
        return false;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        IRefinementSet set = this.getRefinementSet(stack);
        if (set == null) {
            return super.getName(stack);
        }
        return Component.translatable((String)this.getDescriptionId()).append(" ").append(set.getName()).withStyle(set.getRarity().color);
    }

    @Override
    @Nullable
    public IRefinementSet getRefinementSet(@NotNull ItemStack stack) {
        return ((EffectiveRefinementSet)stack.getOrDefault(ModDataComponents.REFINEMENT_SET, (Object)EffectiveRefinementSet.EMPTY)).set();
    }

    @Override
    public IRefinementItem.AccessorySlotType getSlotType() {
        return this.type;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        if (!worldIn.isClientSide()) {
            ItemStack stack = playerIn.getItemInHand(handIn);
            if (FactionPlayerHandler.getCurrentFactionPlayer(playerIn).map(IFactionPlayer::getSkillHandler).map(sh -> sh.equipRefinementItem(stack)).orElse(false).booleanValue()) {
                return InteractionResultHolder.consume((Object)ItemStack.EMPTY);
            }
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        ItemStack stack = this.getDefaultInstance();
        ModRegistries.REFINEMENT_SETS.stream().filter(set -> this.getExclusiveFaction(stack) == null || set.getFaction() == this.getExclusiveFaction(stack)).filter(set -> set.getSlotType().map(s -> s == this.getSlotType()).orElse(true)).map(set -> {
            ItemStack s = stack.copy();
            this.applyRefinementSet(s, (IRefinementSet)set);
            return s;
        }).forEach(item -> output.accept(item, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY));
        output.accept(stack, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
    }
}

