/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.ModDisplayItemGenerator;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.items.component.VampireBookContents;
import de.teamlapen.vampirism.network.ClientboundOpenVampireBookPacket;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireBookItem
extends Item
implements ModDisplayItemGenerator.CreativeTabItemProvider {
    public VampireBookItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        VampireBookContents contents = (VampireBookContents)stack.get(ModDataComponents.VAMPIRE_BOOK);
        if (contents != null) {
            String s = contents.author();
            if (!StringUtil.isNullOrEmpty((String)s)) {
                tooltip.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{s}).withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.literal((String)"Vampirism knowledge").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public void generateCreativeTab(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        Collection<ItemStack> items = VampireBookManager.getInstance().getAllBookItems();
        items.stream().findAny().ifPresent(stack -> output.accept(stack, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY));
        items.forEach(stack -> output.accept(stack, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY));
    }

    public ItemStack contentInstance(VampireBookManager.BookContext context) {
        ItemStack stack = this.getDefaultInstance();
        VampireBookContents.addFromBook(stack, context);
        return stack;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        VampireBookContents contents = (VampireBookContents)stack.get(ModDataComponents.VAMPIRE_BOOK);
        if (contents != null && !StringUtil.isNullOrEmpty((String)contents.title())) {
            return Component.literal((String)contents.title());
        }
        return super.getName(stack);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!worldIn.isClientSide && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.connection.send((CustomPacketPayload)new ClientboundOpenVampireBookPacket(VampireBookContents.get(stack).id()));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

