/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireClothingItem
extends ArmorItem
implements IFactionExclusiveItem {
    public VampireClothingItem(@NotNull ArmorItem.Type type, Holder<ArmorMaterial> material) {
        super(material, type, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(15)));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addFactionToolTips(stack, context, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return super.canEquip(stack, armorType, entity) && Helper.isVampire((Entity)entity);
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            if (pSlotId >= 36 && pSlotId <= 39) {
                if (living.tickCount % 16 == 8 && !Helper.isVampire((Entity)living)) {
                    living.addEffect(new MobEffectInstance(ModEffects.POISON, 20, 1));
                }
                if (pStack.getItem() == ModItems.VAMPIRE_CLOTHING_CROWN.get() && pStack.has(DataComponents.CUSTOM_NAME) && "10000000".equals(pStack.getHoverName().getString()) && VampirismAPI.settings().isSettingTrue("vampirism:10000000d")) {
                    UtilLib.spawnParticlesAroundEntity(living, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, 0.5, 4);
                    if (living.tickCount % 16 == 4) {
                        living.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 30, 0));
                        living.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 100, 2));
                    }
                }
            }
        }
    }
}

