/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.vampirealtar;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.blocks.DarkStoneBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.core.ModStructures;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class VampireAltarPieces {
    private static final ResourceLocation LOCATION_SMALL = VResourceLocation.mod("altar_small");
    private static final ResourceLocation LOCATION_BIG = VResourceLocation.mod("altar_big");
    private static final ResourceLocation LOCATION_SMALL_OLD = VResourceLocation.mod("altar_small_old");
    private static final ResourceLocation LOCATION_BIG_OLD = VResourceLocation.mod("altar_big_old");

    public static void addPieces(StructureTemplateManager structureTemplateManager, StructurePieceAccessor pieceAccessor, RandomSource random, BlockPos pos) {
        ResourceLocation location = (double)random.nextFloat() < 0.2 ? ((double)random.nextFloat() < 0.3 ? LOCATION_BIG_OLD : LOCATION_BIG) : ((double)random.nextFloat() < 0.5 ? LOCATION_SMALL_OLD : LOCATION_SMALL);
        pieceAccessor.addPiece((StructurePiece)new VampireAltarPiece(structureTemplateManager, location, pos));
    }

    public static class VampireAltarPiece
    extends TemplateStructurePiece {
        public VampireAltarPiece(StructureTemplateManager pStructureTemplateManager, ResourceLocation pLocation, BlockPos pPos) {
            super((StructurePieceType)ModStructures.VAMPIRE_ALTAR_PIECE.get(), 0, pStructureTemplateManager, pLocation, pLocation.toString(), VampireAltarPiece.makeSettings(), pPos);
        }

        public VampireAltarPiece(StructureTemplateManager pStructureTemplateManager, CompoundTag pTag) {
            super((StructurePieceType)ModStructures.VAMPIRE_ALTAR_PIECE.get(), pTag, pStructureTemplateManager, id -> VampireAltarPiece.makeSettings());
        }

        protected void handleDataMarker(@NotNull String pName, @NotNull BlockPos pPos, @NotNull ServerLevelAccessor pLevel, @NotNull RandomSource pRandom, @NotNull BoundingBox pBox) {
            switch (pName) {
                case "chest": {
                    pLevel.setBlock(pPos, ((DarkStoneBlock)((Object)ModBlocks.DARK_STONE_BRICKS.get())).defaultBlockState(), 3);
                    BlockEntity blockEntity = pLevel.getBlockEntity(pPos.below());
                    if (!(blockEntity instanceof ChestBlockEntity)) break;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    chest.setLootTable(ModLootTables.CHEST_VAMPIRE_ALTAR, pRandom.nextLong());
                    break;
                }
                case "entity": {
                    pLevel.removeBlock(pPos, false);
                    if (VampirismAPI.sundamageRegistry().hasSunDamage((LevelAccessor)pLevel, pPos)) break;
                    AdvancedVampireEntity advancedVampireEntity = (AdvancedVampireEntity)((EntityType)ModEntities.ADVANCED_VAMPIRE.get()).create((Level)pLevel.getLevel());
                    advancedVampireEntity.setPos((double)pPos.getX() + 0.5, pPos.getY(), (double)pPos.getZ() + 0.5);
                    pLevel.addFreshEntity((Entity)advancedVampireEntity);
                }
            }
        }

        @NotNull
        private static StructurePlaceSettings makeSettings() {
            return new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        }
    }
}

