/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.RefinementItem;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefinementSetFunction
extends LootItemConditionalFunction {
    public static final MapCodec<RefinementSetFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> RefinementSetFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)IFaction.CODEC.fieldOf("faction").forGetter(l -> l.faction)).apply((Applicative)inst, RefinementSetFunction::new));
    @Nullable
    public final IFaction<?> faction;

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder(IFaction<?> faction) {
        return RefinementSetFunction.simpleBuilder(conditions -> new RefinementSetFunction((List<LootItemCondition>)conditions, faction));
    }

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder() {
        return RefinementSetFunction.simpleBuilder(conditions -> new RefinementSetFunction((List<LootItemCondition>)conditions, null));
    }

    public RefinementSetFunction(@NotNull List<LootItemCondition> conditionsIn, @Nullable IFaction<?> faction) {
        super(conditionsIn);
        this.faction = faction;
    }

    @NotNull
    public LootItemFunctionType<RefinementSetFunction> getType() {
        return (LootItemFunctionType)ModLoot.ADD_REFINEMENT_SET.get();
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        IRefinementSet set;
        if (stack.getItem() instanceof IRefinementItem && (set = RefinementItem.getRandomRefinementForItem(this.faction, (IRefinementItem)stack.getItem())) != null) {
            ((IRefinementItem)stack.getItem()).applyRefinementSet(stack, set);
        }
        return stack;
    }
}

