/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.core.ModLoot;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;

public class SetItemBloodChargeFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetItemBloodChargeFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> SetItemBloodChargeFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)NumberProviders.CODEC.fieldOf("charge").forGetter(l -> l.charge)).apply((Applicative)inst, SetItemBloodChargeFunction::new));
    private final NumberProvider charge;

    @NotNull
    public static LootItemConditionalFunction.Builder<?> builder(NumberProvider p_215931_0_) {
        return SetItemBloodChargeFunction.simpleBuilder(p_215930_1_ -> new SetItemBloodChargeFunction((List<LootItemCondition>)p_215930_1_, p_215931_0_));
    }

    private SetItemBloodChargeFunction(@NotNull List<LootItemCondition> conditions, NumberProvider charge) {
        super(conditions);
        this.charge = charge;
    }

    @NotNull
    public LootItemFunctionType<SetItemBloodChargeFunction> getType() {
        return (LootItemFunctionType)ModLoot.SET_ITEM_BLOOD_CHARGE.get();
    }

    @NotNull
    public ItemStack run(@NotNull ItemStack stack, @NotNull LootContext context) {
        ((IBloodChargeable)stack.getItem()).charge(stack, this.charge.getInt(context));
        return stack;
    }
}

