/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.ItemDataUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class SetOilFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetOilFunction> CODEC = RecordCodecBuilder.mapCodec(inst -> SetOilFunction.commonFields((RecordCodecBuilder.Instance)inst).and((App)ModRegistries.OILS.holderByNameCodec().optionalFieldOf("oil").forGetter(l -> Optional.ofNullable(l.oil))).apply((Applicative)inst, SetOilFunction::new));
    private final Holder<IOil> oil;
    private final boolean random;

    SetOilFunction(List<LootItemCondition> conditions, Optional<Holder<IOil>> oil) {
        super(conditions);
        if (oil.isPresent()) {
            this.oil = oil.get();
            this.random = false;
        } else {
            this.oil = null;
            this.random = true;
        }
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack pStack, @NotNull LootContext pContext) {
        Holder oil = this.oil;
        if (this.random) {
            List values = ModRegistries.OILS.holders().toList();
            oil = (Holder)values.stream().skip((int)((double)values.size() * pContext.getRandom().nextDouble())).findFirst().orElseThrow(() -> new IllegalStateException("No oils registered"));
        }
        return ItemDataUtils.setOil(pStack, oil);
    }

    public static LootItemConditionalFunction.Builder<?> setOil(@NotNull Holder<IOil> oil) {
        return SetOilFunction.simpleBuilder(conditions -> new SetOilFunction((List<LootItemCondition>)conditions, Optional.of(oil)));
    }

    public static LootItemConditionalFunction.Builder<?> random() {
        return SetOilFunction.simpleBuilder(conditions -> new SetOilFunction((List<LootItemCondition>)conditions, Optional.empty()));
    }

    @NotNull
    public LootItemFunctionType<SetOilFunction> getType() {
        return (LootItemFunctionType)ModLoot.SET_OIL.get();
    }
}

