/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.util;

import fox.mods.access_denied.AccessDenied;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtils {
    public static boolean hasItemInSlot(Player player, Item item) {
        if (!AccessDenied.curios) {
            return false;
        }
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(curiosInventory -> {
            for (String slotId : curiosInventory.getCurios().keySet()) {
                Optional stacksHandler = curiosInventory.getStacksHandler(slotId);
                if (!stacksHandler.isPresent()) continue;
                for (int i = 0; i < ((ICurioStacksHandler)stacksHandler.get()).getSlots(); ++i) {
                    ItemStack stack = ((ICurioStacksHandler)stacksHandler.get()).getStacks().getStackInSlot(i);
                    if (stack.getItem() != item) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }

    public static void removeItemFromSlot(Player player, Item item) {
        if (!AccessDenied.curios) {
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosInventory -> {
            for (String slotIdentifier : curiosInventory.getCurios().keySet()) {
                Optional stacksHandler = curiosInventory.getStacksHandler(slotIdentifier);
                if (!stacksHandler.isPresent()) continue;
                IDynamicStackHandler stacks = ((ICurioStacksHandler)stacksHandler.get()).getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.getItem() != item) continue;
                    stacks.setStackInSlot(i, ItemStack.EMPTY);
                    return;
                }
            }
        });
    }
}

