/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.access_denied.util;

import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class RegistriesUtils {
    public static Item itemFromRegistryName(String registryName) {
        if (registryName == null) {
            return Items.AIR;
        }
        return (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)registryName));
    }

    public static Holder.Reference<MobEffect> effectFromRegistryName(String registryName) {
        if (registryName == null) {
            registryName = "minecraft:instant_health";
        }
        ResourceLocation id = ResourceLocation.parse((String)registryName);
        Optional holder = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)id));
        return (Holder.Reference)holder.orElseThrow(() -> new IllegalArgumentException("Invalid MobEffect ID"));
    }

    public static String getEffectDisplayName(Holder.Reference<MobEffect> effect) {
        if (effect == null) {
            return "";
        }
        Component displayName = ((MobEffect)effect.value()).getDisplayName();
        return displayName.getString();
    }

    public static String getAdvancementDisplayName(MinecraftServer server, String advancementRegistryId) {
        if (advancementRegistryId == null) {
            return "";
        }
        ResourceLocation id = ResourceLocation.parse((String)advancementRegistryId);
        ServerAdvancementManager mgr = server.getAdvancements();
        AdvancementHolder holder = mgr.get(id);
        if (holder == null) {
            return "";
        }
        Component titleComp = Advancement.name((AdvancementHolder)holder);
        String title = titleComp.getString();
        return title;
    }

    public static String getMobNameFromRegistryName(String registryName) {
        if (registryName == null) {
            return null;
        }
        EntityType entityType = EntityType.byString((String)registryName).orElse(null);
        if (entityType == null) {
            return null;
        }
        String translationKey = entityType.getDescriptionId();
        return Component.translatable((String)translationKey).getString();
    }

    public static String getBlockNameFromRegistryName(String registryName) {
        if (registryName == null) {
            return null;
        }
        ResourceLocation resourceLocation = ResourceLocation.parse((String)registryName);
        Block block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
        return block.getName().getString();
    }
}

