/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei;

import appeng.items.parts.FacadeItem;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

class FacadeRegistryPlugin
implements ISimpleRecipeManagerPlugin<RecipeHolder<CraftingRecipe>> {
    private final IVanillaRecipeFactory vanillaRecipeFactory;
    private final FacadeItem itemFacade;
    private final ItemStack cableAnchor;

    FacadeRegistryPlugin(IVanillaRecipeFactory vanillaRecipeFactory, FacadeItem itemFacade, ItemStack cableAnchor) {
        this.vanillaRecipeFactory = vanillaRecipeFactory;
        this.itemFacade = itemFacade;
        this.cableAnchor = cableAnchor;
    }

    public boolean isHandledInput(ITypedIngredient<?> input) {
        ItemStack stackFocus = input.getItemStack().orElse(ItemStack.EMPTY);
        return !this.itemFacade.createFacadeForItem(stackFocus, true).isEmpty();
    }

    public boolean isHandledOutput(ITypedIngredient<?> output) {
        ItemStack stackFocus = output.getItemStack().orElse(ItemStack.EMPTY);
        return stackFocus.getItem() instanceof FacadeItem;
    }

    public List<RecipeHolder<CraftingRecipe>> getRecipesForInput(ITypedIngredient<?> input) {
        ItemStack focusStack = input.getItemStack().orElse(ItemStack.EMPTY);
        ItemStack facade = this.itemFacade.createFacadeForItem(focusStack, false);
        if (!facade.isEmpty()) {
            return List.of(this.make(focusStack, this.cableAnchor, facade));
        }
        return List.of();
    }

    public List<RecipeHolder<CraftingRecipe>> getRecipesForOutput(ITypedIngredient<?> output) {
        ItemStack focusStack = output.getItemStack().orElse(ItemStack.EMPTY);
        Item item = focusStack.getItem();
        if (item instanceof FacadeItem) {
            FacadeItem facadeItem = (FacadeItem)item;
            ItemStack textureItem = facadeItem.getTextureItem(focusStack);
            return List.of(this.make(textureItem, this.cableAnchor, focusStack));
        }
        return List.of();
    }

    public List<RecipeHolder<CraftingRecipe>> getAllRecipes() {
        return List.of();
    }

    private RecipeHolder<CraftingRecipe> make(ItemStack textureItem, ItemStack cableAnchor, ItemStack result) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)textureItem.getItem());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)("facade/" + itemId.getNamespace() + "/" + itemId.getPath()));
        ItemStack output = result.copyWithCount(4);
        CraftingRecipe recipe = this.vanillaRecipeFactory.createShapedRecipeBuilder(CraftingBookCategory.MISC, List.of(output)).define(Character.valueOf('a'), Ingredient.of((ItemStack[])new ItemStack[]{cableAnchor})).define(Character.valueOf('i'), Ingredient.of((ItemStack[])new ItemStack[]{textureItem})).pattern(" a ").pattern("aia").pattern(" a ").build();
        return new RecipeHolder(id, (Recipe)recipe);
    }
}

