/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.categories;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.ViewBasedCategory;
import tamaized.ae2jeiintegration.integration.modules.jei.drawables.CyclingDrawable;
import tamaized.ae2jeiintegration.integration.modules.jei.widgets.LabelWidget;
import tamaized.ae2jeiintegration.integration.modules.jei.widgets.WidgetFactory;

public class CertusGrowthCategory
extends ViewBasedCategory<Page> {
    public static final RecipeType<Page> TYPE = RecipeType.create((String)"ae2", (String)"certus_growth", Page.class);
    private final List<ItemStack> BUDDING_QUARTZ_VARIANTS = List.of(AEBlocks.DAMAGED_BUDDING_QUARTZ.stack(), AEBlocks.CHIPPED_BUDDING_QUARTZ.stack(), AEBlocks.FLAWED_BUDDING_QUARTZ.stack(), AEBlocks.FLAWLESS_BUDDING_QUARTZ.stack());
    private final List<ItemStack> BUDDING_QUARTZ_DECAY_ORDER = List.of(AEBlocks.QUARTZ_BLOCK.stack(), AEBlocks.DAMAGED_BUDDING_QUARTZ.stack(), AEBlocks.CHIPPED_BUDDING_QUARTZ.stack(), AEBlocks.FLAWED_BUDDING_QUARTZ.stack());
    private final List<ItemStack> BUD_GROWTH_STAGES = List.of(AEBlocks.SMALL_QUARTZ_BUD.stack(), AEBlocks.MEDIUM_QUARTZ_BUD.stack(), AEBlocks.LARGE_QUARTZ_BUD.stack(), AEBlocks.QUARTZ_CLUSTER.stack());
    private final int centerX = this.background.getWidth() / 2;

    public CertusGrowthCategory(IGuiHelper guiHelper) {
        super(guiHelper, CyclingDrawable.forItems(guiHelper, new ItemLike[]{AEBlocks.SMALL_QUARTZ_BUD, AEBlocks.MEDIUM_QUARTZ_BUD, AEBlocks.LARGE_QUARTZ_BUD, AEBlocks.QUARTZ_CLUSTER}), (Component)ItemModText.CERTUS_QUARTZ_GROWTH.text(), (IDrawable)guiHelper.createBlankDrawable(150, 60));
    }

    public RecipeType<Page> getRecipeType() {
        return TYPE;
    }

    @Override
    protected ViewBasedCategory.View getView(Page page) {
        return switch (page.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new BudGrowthView();
            case 1, 2 -> new LootView(page);
            case 3 -> new BuddingQuartzDecayView();
            case 4 -> new BuddingQuartzMovingView();
            case 5 -> new GettingBuddingQuartzView();
            case 6 -> new FlawlessBuddingQuartzView();
            case 7 -> new BuddingQuartzAccelerationView();
        };
    }

    public static enum Page {
        BUD_GROWTH,
        BUD_LOOT,
        CLUSTER_LOOT,
        BUDDING_QUARTZ_DECAY,
        BUDDING_QUARTZ_MOVING,
        GETTING_BUDDING_QUARTZ,
        FLAWLESS_BUDDING_QUARTZ,
        BUDDING_QUARTZ_ACCELERATION;

    }

    private class BudGrowthView
    implements ViewBasedCategory.View {
        private BudGrowthView() {
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            MutableComponent text = ItemModText.QUARTZ_BUDS_GROW_ON_BUDDING_QUARTZ.text();
            builder.addWidget((IRecipeWidget)new LabelWidget(CertusGrowthCategory.this.centerX, 0, (Component)text).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
            builder.addWidget((IRecipeWidget)WidgetFactory.unfilledArrow(CertusGrowthCategory.this.guiHelper, CertusGrowthCategory.this.centerX - 12, 25));
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            builder.addSlot(RecipeIngredientRole.CATALYST, CertusGrowthCategory.this.centerX - 40, 25).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
            builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 25).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUD_GROWTH_STAGES);
        }
    }

    private class LootView
    implements ViewBasedCategory.View {
        private final Page page;

        public LootView(Page page) {
            this.page = page;
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            MutableComponent text = this.page == Page.BUD_LOOT ? ItemModText.BUDS_DROP_DUST_WHEN_NOT_FULLY_GROWN.text() : ItemModText.FULLY_GROWN_BUDS_DROP_CRYSTALS.text();
            builder.addWidget((IRecipeWidget)new LabelWidget(CertusGrowthCategory.this.centerX, 0, (Component)text).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
            builder.addWidget((IRecipeWidget)WidgetFactory.unfilledArrow(CertusGrowthCategory.this.guiHelper, CertusGrowthCategory.this.centerX - 12, 25));
            if (this.page == Page.CLUSTER_LOOT) {
                MutableComponent text1 = ItemModText.FORTUNE_APPLIES.text();
                builder.addWidget((IRecipeWidget)new LabelWidget(CertusGrowthCategory.this.centerX, 50, (Component)text1).bodyText());
            }
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            List<ItemStack> input = this.page == Page.BUD_LOOT ? List.of(AEBlocks.SMALL_QUARTZ_BUD.stack(), AEBlocks.MEDIUM_QUARTZ_BUD.stack(), AEBlocks.LARGE_QUARTZ_BUD.stack()) : List.of(AEBlocks.QUARTZ_CLUSTER.stack());
            builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 40, 25).setStandardSlotBackground().addItemStacks(input);
            ItemStack finalResult = this.page == Page.BUD_LOOT ? AEItems.CERTUS_QUARTZ_DUST.stack() : AEItems.CERTUS_QUARTZ_CRYSTAL.stack(4);
            builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 25).setStandardSlotBackground().addItemStack(finalResult);
        }
    }

    private class BuddingQuartzDecayView
    implements ViewBasedCategory.View {
        private BuddingQuartzDecayView() {
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            MutableComponent text1 = ItemModText.IMPERFECT_BUDDING_QUARTZ_DECAYS.text();
            builder.addWidget((IRecipeWidget)new LabelWidget(CertusGrowthCategory.this.centerX, 0, (Component)text1).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
            builder.addWidget((IRecipeWidget)WidgetFactory.unfilledArrow(CertusGrowthCategory.this.guiHelper, CertusGrowthCategory.this.centerX - 12, 30));
            int decayChancePct = 8;
            MutableComponent text = ItemModText.DECAY_CHANCE.text(new Object[]{decayChancePct});
            builder.addWidget((IRecipeWidget)new LabelWidget(CertusGrowthCategory.this.centerX, 50, (Component)text).bodyText());
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            IRecipeSlotBuilder slot1 = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 40, 30).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
            IRecipeSlotBuilder slot2 = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 30).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_DECAY_ORDER);
            builder.createFocusLink(new IIngredientAcceptor[]{slot1, slot2});
        }
    }

    private class BuddingQuartzMovingView
    implements ViewBasedCategory.View {
        private BuddingQuartzMovingView() {
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            IRecipeSlotBuilder slot1 = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 40, 0).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
            IRecipeSlotBuilder slot2 = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, CertusGrowthCategory.this.centerX + 40 - 18, 0).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_DECAY_ORDER);
            builder.createFocusLink(new IIngredientAcceptor[]{slot1, slot2});
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            builder.addWidget((IRecipeWidget)WidgetFactory.unfilledArrow(CertusGrowthCategory.this.guiHelper, CertusGrowthCategory.this.centerX - 12, 0));
            builder.addScrollBoxWidget(CertusGrowthCategory.this.getWidth(), CertusGrowthCategory.this.getHeight() - 20, 0, 20).setContents(List.of(ItemModText.BUDDING_QUARTZ_DECAYS_WHEN_BROKEN.text().withColor(0x7E7E7E), ItemModText.SILK_TOUCH_PREVENTS_DECAY_FOR_IMPERFECT.text().withColor(0x7E7E7E), ItemModText.SPATIAL_IO_NEVER_CAUSES_ANY_DECAY.text().withColor(0x7E7E7E)));
        }
    }

    private class GettingBuddingQuartzView
    implements ViewBasedCategory.View {
        private GettingBuddingQuartzView() {
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            MutableComponent text = ItemModText.BUDDING_QUARTZ_CREATION_AND_WORLDGEN.text();
            builder.addWidget((IRecipeWidget)new LabelWidget(22, 13, (Component)text).bodyText().alignLeft().maxWidth(CertusGrowthCategory.this.background.getWidth() - 20));
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_DECAY_ORDER);
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 22).setStandardSlotBackground().addItemStack(AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.stack());
            builder.addSlot(RecipeIngredientRole.CATALYST, 1, 43).setStandardSlotBackground().addItemStack(AEItems.METEORITE_COMPASS.stack());
        }
    }

    private class FlawlessBuddingQuartzView
    implements ViewBasedCategory.View {
        private FlawlessBuddingQuartzView() {
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            MutableComponent text = ItemModText.FLAWLESS_BUDDING_QUARTZ_DESCRIPTION.text();
            builder.addWidget((IRecipeWidget)new LabelWidget(22, 13, (Component)text).bodyText().alignLeft().maxWidth(CertusGrowthCategory.this.background.getWidth() - 20));
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 1, 13).setStandardSlotBackground().addItemStack(AEBlocks.FLAWLESS_BUDDING_QUARTZ.stack());
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 33).setStandardSlotBackground().addItemStack(AEItems.METEORITE_COMPASS.stack());
        }
    }

    private class BuddingQuartzAccelerationView
    implements ViewBasedCategory.View {
        private BuddingQuartzAccelerationView() {
        }

        @Override
        public void createRecipeExtras(IRecipeExtrasBuilder builder, IFocusGroup focuses) {
            int centerX = CertusGrowthCategory.this.background.getWidth() / 2;
            MutableComponent text = ItemModText.CRYSTAL_GROWTH_ACCELERATORS_EFFECT.text();
            builder.addWidget((IRecipeWidget)new LabelWidget(centerX, 0, (Component)text).bodyText().maxWidth(CertusGrowthCategory.this.background.getWidth()));
            builder.addWidget((IRecipeWidget)new LabelWidget(centerX, 45, (Component)Component.literal((String)"+")));
        }

        @Override
        public void buildSlots(IRecipeLayoutBuilder builder) {
            builder.addSlot(RecipeIngredientRole.INPUT, CertusGrowthCategory.this.centerX - 8 - 16, 40).setStandardSlotBackground().addItemStacks(CertusGrowthCategory.this.BUDDING_QUARTZ_VARIANTS);
            builder.addSlot(RecipeIngredientRole.CATALYST, CertusGrowthCategory.this.centerX + 8, 40).setStandardSlotBackground().addItemStack(AEBlocks.GROWTH_ACCELERATOR.stack());
        }
    }
}

