/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.mojang.serialization.MapCodec;
import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.simpleCodec(ShelfBlock::new);
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NL = Block.box((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape NR = Block.box((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)14.0, (double)16.0);
    protected static final VoxelShape T_NL = Shapes.or((VoxelShape)TOP, (VoxelShape)NL);
    protected static final VoxelShape T_NR = Shapes.or((VoxelShape)TOP, (VoxelShape)NR);
    protected static final VoxelShape T_NLR = Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{NL, NR});
    protected static final VoxelShape T_EL = ShapeUtil.rotateShape(T_NL, Direction.EAST);
    protected static final VoxelShape T_ER = ShapeUtil.rotateShape(T_NR, Direction.EAST);
    protected static final VoxelShape T_ELR = ShapeUtil.rotateShape(T_NLR, Direction.EAST);
    protected static final VoxelShape T_SL = ShapeUtil.rotateShape(T_NL, Direction.SOUTH);
    protected static final VoxelShape T_SR = ShapeUtil.rotateShape(T_NR, Direction.SOUTH);
    protected static final VoxelShape T_SLR = ShapeUtil.rotateShape(T_NLR, Direction.SOUTH);
    protected static final VoxelShape T_WL = ShapeUtil.rotateShape(T_NL, Direction.WEST);
    protected static final VoxelShape T_WR = ShapeUtil.rotateShape(T_NLR, Direction.WEST);
    protected static final VoxelShape T_WLR = ShapeUtil.rotateShape(T_NLR, Direction.WEST);

    public MapCodec<ShelfBlock> codec() {
        return CODEC;
    }

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hitResult.getDirection() != Direction.UP) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (!(blockentity instanceof ShelfBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
        Direction facing = (Direction)state.getValue((Property)FACING);
        int slot = BlockPart.get2D(pos, hitResult.getLocation(), facing.getClockWise(), facing, 2, 2);
        if (!stack.isEmpty()) {
            if (!level.isClientSide && shelfBE.placeItem(player.getAbilities().instabuild ? stack.copy() : stack, slot)) {
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        if (shelfBE.removeItem(slot, player, level)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
            Containers.dropContents((Level)level, (BlockPos)pos, shelfBE.getItems());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.getValue(TYPE));
        if (direction == Direction.NORTH) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_NLR;
                case HorizontalConnectionType.LEFT -> T_NL;
                case HorizontalConnectionType.RIGHT -> T_NR;
                default -> TOP;
            };
        }
        if (direction == Direction.EAST) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_ELR;
                case HorizontalConnectionType.LEFT -> T_EL;
                case HorizontalConnectionType.RIGHT -> T_ER;
                default -> TOP;
            };
        }
        if (direction == Direction.SOUTH) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_SLR;
                case HorizontalConnectionType.LEFT -> T_SL;
                case HorizontalConnectionType.RIGHT -> T_SR;
                default -> TOP;
            };
        }
        return switch (type) {
            case HorizontalConnectionType.SINGLE -> T_WLR;
            case HorizontalConnectionType.LEFT -> T_WL;
            case HorizontalConnectionType.RIGHT -> T_WR;
            default -> TOP;
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean r_side;
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        BlockState above = level.getBlockState(currentPos.above());
        if (direction == Direction.UP && above.isFaceSturdy((BlockGetter)level, currentPos, Direction.DOWN) && !above.getVisualShape((BlockGetter)level, currentPos.above(), CollisionContext.empty()).isEmpty() && (blockEntity = level.getBlockEntity(currentPos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockEntity;
            shelfBE.removeAllItems();
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction dirL = facing.getClockWise();
        Direction dirR = facing.getCounterClockWise();
        if (direction != dirL && direction != dirR) {
            return state;
        }
        BlockState l_state = level.getBlockState(currentPos.relative(dirL));
        BlockState r_state = level.getBlockState(currentPos.relative(dirR));
        boolean l_side = l_state.getBlock() instanceof ShelfBlock && l_state.getValue((Property)FACING) == facing;
        boolean bl = r_side = r_state.getBlock() instanceof ShelfBlock && r_state.getValue((Property)FACING) == facing;
        HorizontalConnectionType type = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

