/*
 * Decompiled with CFR 0.152.
 */
package com.httpedro.attributesetter;

import com.httpedro.attributesetter.ASLivingEntity;
import com.httpedro.attributesetter.AttributeSetterAPI;
import com.httpedro.attributesetter.DataLoginSyncPacket;
import com.httpedro.attributesetter.DataReloader;
import com.httpedro.attributesetter.compat.CuriosCompat;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="attributesetter")
public class Attributesetter {
    public static final UUID DEFAULT_UUID = UUID.fromString("21ef99f1-c77a-42cf-ba8f-a59cf69ce7a6");
    public static final UUID BASE_UUID = UUID.fromString("b697bf19-6a3a-4baf-89ce-5d4a3422a3a4");
    static final DataReloader dr = new DataReloader();
    public static final String MODID = "attributesetter";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";

    public Attributesetter(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerPayload);
        if (ModList.get().isLoaded("curios")) {
            NeoForge.EVENT_BUS.register((Object)new CuriosCompat());
        }
    }

    public void registerPayload(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION);
        registrar.configurationToClient(DataLoginSyncPacket.TYPE, DataLoginSyncPacket.DECODER, DataLoginSyncPacket.HANDLER);
    }

    @SubscribeEvent
    public void datapackReload(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)dr);
    }

    @SubscribeEvent
    public void syncData(OnDatapackSyncEvent e) {
    }

    @SubscribeEvent
    public void onItemAttribute(ItemAttributeModifierEvent e) {
        ItemStack stack = e.getItemStack();
        Item item = stack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        for (Map.Entry<ResourceLocation, Map<EquipmentSlotGroup, Map<Holder<Attribute>, Double>>> entry : AttributeSetterAPI.BASE_TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)entry.getKey()))) continue;
            this.applyBases(e, entry);
        }
        for (Map.Entry<ResourceLocation, Map<EquipmentSlotGroup, Map<Holder<Attribute>, Double>>> entry : AttributeSetterAPI.BASE_ITEM_MODIFIERS.entrySet()) {
            if (!entry.getKey().equals((Object)id)) continue;
            this.applyBases(e, entry);
        }
        for (Map.Entry<ResourceLocation, Map<EquipmentSlotGroup, Map<Holder<Attribute>, Double>>> entry : AttributeSetterAPI.TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)entry.getKey()))) continue;
            for (EquipmentSlotGroup slot : entry.getValue().keySet()) {
                for (Map.Entry<Holder<Attribute>, Double> modEntry : entry.getValue().get(slot).entrySet()) {
                    e.addModifier(modEntry.getKey(), (AttributeModifier)modEntry.getValue(), slot);
                }
            }
        }
        Map modifiers = AttributeSetterAPI.ITEM_MODIFIERS.getOrDefault(id, null);
        if (modifiers != null) {
            for (EquipmentSlotGroup slot : modifiers.keySet()) {
                for (Map.Entry mod : ((Map)modifiers.get(slot)).entrySet()) {
                    e.addModifier((Holder)mod.getKey(), (AttributeModifier)mod.getValue(), slot);
                }
            }
        }
    }

    private void applyBases(ItemAttributeModifierEvent e, Map.Entry<ResourceLocation, Map<EquipmentSlotGroup, Map<Holder<Attribute>, Double>>> entry) {
        for (EquipmentSlotGroup slot : entry.getValue().keySet()) {
            for (Map.Entry<Holder<Attribute>, Double> modEntry : entry.getValue().get(slot).entrySet()) {
                e.removeAllModifiersFor(modEntry.getKey());
                e.addModifier(modEntry.getKey(), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"base_mod"), modEntry.getValue().doubleValue(), AttributeModifier.Operation.ADD_VALUE), slot);
            }
        }
    }

    private void processEntity(LivingEntity le) {
        if (((ASLivingEntity)le).as$isLoaded()) {
            return;
        }
        ((ASLivingEntity)le).as$setLoaded();
        ResourceLocation entityType = BuiltInRegistries.ENTITY_TYPE.getKey((Object)le.getType());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)entityType.getNamespace(), (String)entityType.getPath());
        for (Map.Entry<ResourceLocation, Map<Holder<Attribute>, Double>> entry : AttributeSetterAPI.BASE_TAG_MODIFIERS.entrySet()) {
            if (!le.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)entry.getKey()))) continue;
            for (Map.Entry<Holder<Attribute>, Double> modEntry : entry.getValue().entrySet()) {
                AttributeInstance attributeInstance = le.getAttribute(modEntry.getKey());
                if (attributeInstance == null) continue;
                attributeInstance.setBaseValue(modEntry.getValue().doubleValue());
            }
        }
        Map baseMods = AttributeSetterAPI.BASE_MODIFIERS.getOrDefault(id, null);
        if (baseMods != null) {
            for (Map.Entry entry : baseMods.entrySet()) {
                AttributeInstance attrInstance2 = le.getAttribute((Holder)entry.getKey());
                if (attrInstance2 == null) continue;
                attrInstance2.setBaseValue(((Double)entry.getValue()).doubleValue());
            }
        }
        for (Map.Entry<ResourceLocation, Map<Holder<Attribute>, AttributeModifier>> entry : AttributeSetterAPI.TAG_MODIFIERS.entrySet()) {
            if (!le.getType().is(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)entry.getKey()))) continue;
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                AttributeInstance attrInstance3 = le.getAttribute((Holder)entry2.getKey());
                if (attrInstance3 == null) continue;
                attrInstance3.addPermanentModifier((AttributeModifier)entry2.getValue());
            }
        }
        Map map = AttributeSetterAPI.ENTITY_MODIFIERS.getOrDefault(id, null);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeInstance attributeInstance = le.getAttribute((Holder)entry.getKey());
                if (attributeInstance == null) continue;
                attributeInstance.addPermanentModifier((AttributeModifier)entry.getValue());
            }
        }
        le.setHealth(le.getMaxHealth());
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent e) {
        Level world = e.getLevel();
        Entity entity = e.getEntity();
        if (world.isClientSide) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        this.processEntity(le);
    }

    @SubscribeEvent
    public void onEntitySpawn(FinalizeSpawnEvent e) {
        ServerLevelAccessor world = e.getLevel();
        Mob entity = e.getEntity();
        if (world.isClientSide()) {
            return;
        }
        this.processEntity((LivingEntity)entity);
    }
}

