/*
 * Decompiled with CFR 0.152.
 */
package com.httpedro.attributesetter.compat;

import com.google.gson.JsonObject;
import com.httpedro.attributesetter.Attributesetter;
import com.httpedro.attributesetter.DataReloader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;

public class CuriosCompat {
    static final Map<ResourceLocation, Map<String, Map<Holder<Attribute>, AttributeModifier>>> ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Holder<Attribute>, AttributeModifier>>>();
    static final Map<ResourceLocation, Map<String, Map<Holder<Attribute>, AttributeModifier>>> TAG_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Holder<Attribute>, AttributeModifier>>>();
    static final Map<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>> BASE_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>>();
    static final Map<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>> BASE_TAG_ITEM_MODIFIERS = new HashMap<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>>();
    private static int i = 0;

    public static boolean shouldCurioHandle(String idStr, JsonObject json) {
        String slot;
        boolean isTag = idStr.startsWith("#");
        ResourceLocation id = isTag ? ResourceLocation.parse((String)idStr.substring(1)) : ResourceLocation.parse((String)idStr);
        if (json.has("slot")) {
            slot = json.get("slot").getAsString();
            if (!slot.startsWith("curio:")) {
                return false;
            }
        } else {
            return false;
        }
        slot = slot.substring(slot.indexOf(58) + 1);
        double value = json.get("value").getAsDouble();
        Optional attrOpt = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)json.get("attribute").getAsString()));
        if (attrOpt.isEmpty()) {
            Attributesetter.LOGGER.error("Failed to find attribute " + json.get("attribute").getAsString());
            return true;
        }
        Holder.Reference attr = (Holder.Reference)attrOpt.get();
        String opStr = json.has("operation") ? json.get("operation").getAsString() : "ADDITION";
        if (opStr.equalsIgnoreCase("base")) {
            if (isTag) {
                CuriosCompat.registerTagItemBaseAttribute(id, (Holder<Attribute>)attr, value, slot);
            } else {
                CuriosCompat.registerItemBaseAttribute(id, (Holder<Attribute>)attr, value, slot);
            }
        } else {
            if (DataReloader.update.containsKey(opStr.toUpperCase())) {
                opStr = DataReloader.update.get(opStr.toUpperCase());
            }
            AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)opStr.toUpperCase());
            AttributeModifier mod = json.has("id") ? new AttributeModifier(ResourceLocation.parse((String)json.get("id").getAsString()), value, op) : new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"attributesetter", (String)("curios_" + idStr.replace(':', '_') + "_" + i)), value, op);
            if (isTag) {
                CuriosCompat.registerTagItemAttributeModifier(id, (Holder<Attribute>)attr, mod, slot);
            } else {
                CuriosCompat.registerItemAttributeModifier(id, (Holder<Attribute>)attr, mod, slot);
            }
        }
        ++i;
        return true;
    }

    @SubscribeEvent
    public void curioAttributeModifier(CurioAttributeModifierEvent e) {
        Map map;
        AttributeModifier clone;
        Double val;
        ItemStack stack = e.getItemStack();
        String slot = e.getSlotContext().identifier();
        Item item = stack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        for (Map.Entry<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>> entry : BASE_TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)entry.getKey())) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Holder<Attribute>, Double> entry2 : entry.getValue().get(slot).entrySet()) {
                e.removeAttribute(entry2.getKey());
                val = entry2.getValue();
                e.addModifier(entry2.getKey(), new AttributeModifier(e.getId(), val.doubleValue(), AttributeModifier.Operation.ADD_VALUE));
            }
        }
        for (Map.Entry<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>> entry : BASE_ITEM_MODIFIERS.entrySet()) {
            if (!entry.getKey().equals((Object)id) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Object, Double> entry3 : entry.getValue().get(slot).entrySet()) {
                e.removeAttribute((Holder)entry3.getKey());
                val = entry3.getValue();
                e.addModifier((Holder)entry3.getKey(), new AttributeModifier(e.getId(), val.doubleValue(), AttributeModifier.Operation.ADD_VALUE));
            }
        }
        for (Map.Entry<ResourceLocation, Map<String, Map<Holder<Attribute>, Double>>> entry : TAG_ITEM_MODIFIERS.entrySet()) {
            if (!stack.is(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)entry.getKey())) || !entry.getValue().containsKey(slot)) continue;
            for (Map.Entry<Object, Double> entry4 : entry.getValue().get(slot).entrySet()) {
                val = (AttributeModifier)entry4.getValue();
                clone = new AttributeModifier(e.getId(), val.amount(), val.operation());
                e.addModifier((Holder)entry4.getKey(), clone);
            }
        }
        Map modifiers = ITEM_MODIFIERS.getOrDefault(id, null);
        if (modifiers != null && (map = (Map)modifiers.getOrDefault(slot, null)) != null) {
            for (Map.Entry<Object, Double> entry : map.entrySet()) {
                val = (AttributeModifier)entry.getValue();
                clone = new AttributeModifier(e.getId(), val.amount(), val.operation());
                e.addModifier((Holder)entry.getKey(), clone);
            }
        }
    }

    public static void registerItemAttributeModifier(ResourceLocation item, Holder<Attribute> attr, AttributeModifier modifier, String slot) {
        if (!ITEM_MODIFIERS.containsKey(item)) {
            ITEM_MODIFIERS.put(item, new HashMap());
        }
        if (!ITEM_MODIFIERS.get(item).containsKey(slot)) {
            ITEM_MODIFIERS.get(item).put(slot, new HashMap());
        }
        ITEM_MODIFIERS.get(item).get(slot).put(attr, modifier);
    }

    public static void registerTagItemAttributeModifier(ResourceLocation tag, Holder<Attribute> attr, AttributeModifier modifier, String slot) {
        if (!TAG_ITEM_MODIFIERS.containsKey(tag)) {
            TAG_ITEM_MODIFIERS.put(tag, new HashMap());
        }
        if (!TAG_ITEM_MODIFIERS.get(tag).containsKey(slot)) {
            TAG_ITEM_MODIFIERS.get(tag).put(slot, new HashMap());
        }
        TAG_ITEM_MODIFIERS.get(tag).get(slot).put(attr, modifier);
    }

    public static void registerItemBaseAttribute(ResourceLocation item, Holder<Attribute> attr, double baseValue, String slot) {
        if (!BASE_ITEM_MODIFIERS.containsKey(item)) {
            BASE_ITEM_MODIFIERS.put(item, new HashMap());
        }
        if (!BASE_ITEM_MODIFIERS.get(item).containsKey(slot)) {
            BASE_ITEM_MODIFIERS.get(item).put(slot, new HashMap());
        }
        BASE_ITEM_MODIFIERS.get(item).get(slot).put(attr, baseValue);
    }

    public static void registerTagItemBaseAttribute(ResourceLocation tag, Holder<Attribute> attr, double baseValue, String slot) {
        if (!BASE_TAG_ITEM_MODIFIERS.containsKey(tag)) {
            BASE_TAG_ITEM_MODIFIERS.put(tag, new HashMap());
        }
        if (!BASE_TAG_ITEM_MODIFIERS.get(tag).containsKey(slot)) {
            BASE_TAG_ITEM_MODIFIERS.get(tag).put(slot, new HashMap());
        }
        BASE_TAG_ITEM_MODIFIERS.get(tag).get(slot).put(attr, baseValue);
    }
}

