/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.platform.services;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface AzureLibNetwork {
    public static final ResourceLocation ANIM_DATA_SYNC_PACKET_ID = AzureLib.modResource("anim_data_sync");
    public static final ResourceLocation ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("anim_trigger_sync");
    public static final ResourceLocation AZ_BLOCKENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID = AzureLib.modResource("az_blockentity_dispatch_command_sync");
    public static final ResourceLocation AZ_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("az_entity_anim_trigger_sync");
    public static final ResourceLocation AZ_ENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID = AzureLib.modResource("az_entity_dispatch_command_sync");
    public static final ResourceLocation AZ_ITEM_STACK_DISPATCH_COMMAND_SYNC_PACKET_ID = AzureLib.modResource("az_item_stack_dispatch_command_sync");
    public static final ResourceLocation ENTITY_ANIM_DATA_SYNC_PACKET_ID = AzureLib.modResource("entity_anim_data_sync");
    public static final ResourceLocation ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("entity_anim_trigger_sync");
    public static final ResourceLocation BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID = AzureLib.modResource("block_entity_anim_data_sync");
    public static final ResourceLocation BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = AzureLib.modResource("block_entity_anim_trigger_sync");
    public static final ResourceLocation CONFIG_PACKET_ID = AzureLib.modResource("config_packet");
    public static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    public static void sendWithCallback(AbstractPacket packet, IPacketCallback callback) {
        callback.onReadyToSend(packet);
    }

    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);
        if (animatable == null) {
            AzureLib.LOGGER.error("Attempting to retrieve unregistered synced animatable! ({})", (Object)className);
        }
        return animatable;
    }

    public <B extends FriendlyByteBuf, P extends AbstractPacket> void registerPacketInternal(CustomPacketPayload.Type<P> var1, StreamCodec<B, P> var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void registerSyncedAnimatable(GeoAnimatable animatable) {
        AzureLibNetwork azureLibNetwork = this;
        synchronized (azureLibNetwork) {
            GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getClass().toString(), animatable);
            if (existing == null) {
                AzureLib.LOGGER.debug("Registered SyncedAnimatable for {}", animatable.getClass());
            }
        }
    }

    public void sendToTrackingEntityAndSelf(AbstractPacket var1, Entity var2);

    public void sendToEntitiesTrackingChunk(AbstractPacket var1, ServerLevel var2, BlockPos var3);

    public void sendClientPacket(ServerPlayer var1, String var2);

    public void sendToPlayer(AbstractPacket var1, ServerPlayer var2);

    public static interface IPacketCallback {
        public void onReadyToSend(AbstractPacket var1);
    }
}

