/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.parse;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.util.JsonUtil;
import mod.azure.azurelib.core.math.Constant;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.molang.MolangException;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.expressions.MolangValue;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzBoneAnimation;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelib.rewrite.animation.controller.keyframe.AzKeyframeStack;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingType;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypeLoader;
import mod.azure.azurelib.rewrite.animation.easing.AzEasingTypes;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimation;
import mod.azure.azurelib.rewrite.animation.primitive.AzBakedAnimations;
import mod.azure.azurelib.rewrite.animation.primitive.AzKeyframes;
import mod.azure.azurelib.rewrite.animation.primitive.AzLoopType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class AzBakedAnimationsAdapter
implements JsonDeserializer<AzBakedAnimations> {
    private static List<Pair<String, JsonElement>> getKeyframes(JsonElement element) {
        if (element == null) {
            return List.of();
        }
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonArray array = new JsonArray(3);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            array.add((JsonElement)primitive);
            element = array;
        }
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)"0", (Object)array)});
        }
        if (element instanceof JsonObject) {
            JsonObject obj = (JsonObject)element;
            if (obj.has("vector")) {
                return ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)"0", (Object)obj)});
            }
            ObjectArrayList list = new ObjectArrayList();
            for (Map.Entry entry : obj.entrySet()) {
                JsonObject entryObj;
                double timestamp = AzBakedAnimationsAdapter.readTimestamp((String)entry.getKey());
                if (timestamp == 0.0 && !list.isEmpty()) {
                    throw new JsonParseException("Invalid keyframe data - multiple starting keyframes?" + (String)entry.getKey());
                }
                Object v = entry.getValue();
                if (v instanceof JsonObject && !(entryObj = (JsonObject)v).has("vector")) {
                    AzBakedAnimationsAdapter.addBedrockKeyframes(timestamp, entryObj, (List<Pair<String, JsonElement>>)list);
                    continue;
                }
                list.add(Pair.of((Object)String.valueOf(timestamp), (Object)((JsonElement)entry.getValue())));
            }
            return list;
        }
        throw new JsonParseException("Invalid object type provided to getTripletObj, got: " + String.valueOf(element));
    }

    private static void addBedrockKeyframes(double timestamp, JsonObject keyframe, List<Pair<String, JsonElement>> keyframes) {
        boolean addedFrame = false;
        if (keyframe.has("pre")) {
            JsonElement pre = keyframe.get("pre");
            addedFrame = true;
            keyframes.add((Pair<String, JsonElement>)Pair.of((Object)String.valueOf(timestamp == 0.0 ? timestamp : timestamp - 0.001), (Object)(pre.isJsonArray() ? pre.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)pre.getAsJsonObject(), (String)"vector"))));
        }
        if (keyframe.has("post")) {
            JsonArray values;
            JsonElement post = keyframe.get("post");
            JsonArray jsonArray = values = post.isJsonArray() ? post.getAsJsonArray() : GsonHelper.getAsJsonArray((JsonObject)post.getAsJsonObject(), (String)"vector");
            if (keyframe.has("lerp_mode")) {
                JsonObject keyframeObj = new JsonObject();
                keyframeObj.add("vector", (JsonElement)values);
                keyframeObj.add("easing", keyframe.get("lerp_mode"));
                keyframes.add((Pair<String, JsonElement>)Pair.of((Object)String.valueOf(timestamp), (Object)keyframeObj));
            } else {
                keyframes.add((Pair<String, JsonElement>)Pair.of((Object)String.valueOf(timestamp), (Object)values));
            }
            return;
        }
        if (!addedFrame) {
            throw new JsonParseException("Invalid keyframe data - expected array, found " + String.valueOf(keyframe));
        }
    }

    private static double calculateAnimationLength(AzBoneAnimation[] boneAnimations) {
        double length = 0.0;
        for (AzBoneAnimation animation : boneAnimations) {
            length = Math.max(length, animation.rotationKeyframes().getLastKeyframeTime());
            length = Math.max(length, animation.positionKeyframes().getLastKeyframeTime());
            length = Math.max(length, animation.scaleKeyframes().getLastKeyframeTime());
        }
        return length == 0.0 ? Double.MAX_VALUE : length;
    }

    public AzBakedAnimations deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        JsonObject animationJsonList = jsonObj.getAsJsonObject("animations");
        JsonArray includeListJSONObj = jsonObj.getAsJsonArray("includes");
        Object2ObjectOpenHashMap includes = null;
        if (includeListJSONObj != null) {
            includes = new Object2ObjectOpenHashMap(includeListJSONObj.size());
            for (JsonElement entry : includeListJSONObj.asList()) {
                JsonObject obj = entry.getAsJsonObject();
                ResourceLocation fileId = ResourceLocation.parse((String)obj.get("file_id").getAsString());
                for (JsonElement animName : obj.getAsJsonArray("animations")) {
                    String ani = animName.getAsString();
                    if (includes.containsKey(ani)) {
                        AzureLib.LOGGER.warn("Animation {} is already included! File already including: {}  File trying to include from again: {}", (Object)ani, includes.get(ani), (Object)fileId);
                        continue;
                    }
                    includes.put(ani, fileId);
                }
            }
        }
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap(animationJsonList.size());
        for (Map.Entry entry : animationJsonList.entrySet()) {
            try {
                animations.put((String)entry.getKey(), this.bakeAnimation((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), context));
            }
            catch (MolangException ex) {
                AzureLib.LOGGER.error("Unable to parse animation: {}", entry.getKey());
                ex.printStackTrace();
            }
        }
        return new AzBakedAnimations((Map<String, AzBakedAnimation>)animations, (Map<String, ResourceLocation>)includes);
    }

    private AzBakedAnimation bakeAnimation(String name, JsonObject animationObj, JsonDeserializationContext context) throws MolangException {
        double length = animationObj.has("animation_length") ? GsonHelper.getAsDouble((JsonObject)animationObj, (String)"animation_length") * 20.0 : -1.0;
        AzLoopType loopType = AzLoopType.fromJson(animationObj.get("loop"));
        AzBoneAnimation[] boneAnimations = this.bakeBoneAnimations(GsonHelper.getAsJsonObject((JsonObject)animationObj, (String)"bones", (JsonObject)new JsonObject()));
        AzKeyframes keyframes = (AzKeyframes)context.deserialize((JsonElement)animationObj, AzKeyframes.class);
        if (length == -1.0) {
            length = AzBakedAnimationsAdapter.calculateAnimationLength(boneAnimations);
        }
        return new AzBakedAnimation(name, length, loopType, boneAnimations, keyframes);
    }

    private AzBoneAnimation[] bakeBoneAnimations(JsonObject bonesObj) throws MolangException {
        AzBoneAnimation[] animations = new AzBoneAnimation[bonesObj.size()];
        int index = 0;
        for (Map.Entry entry : bonesObj.entrySet()) {
            JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            AzKeyframeStack<AzKeyframe<IValue>> scaleFrames = this.buildKeyframeStack(AzBakedAnimationsAdapter.getKeyframes(entryObj.get("scale")), false);
            AzKeyframeStack<AzKeyframe<IValue>> positionFrames = this.buildKeyframeStack(AzBakedAnimationsAdapter.getKeyframes(entryObj.get("position")), false);
            AzKeyframeStack<AzKeyframe<IValue>> rotationFrames = this.buildKeyframeStack(AzBakedAnimationsAdapter.getKeyframes(entryObj.get("rotation")), true);
            animations[index] = new AzBoneAnimation((String)entry.getKey(), rotationFrames, positionFrames, scaleFrames);
            ++index;
        }
        return animations;
    }

    private AzKeyframeStack<AzKeyframe<IValue>> buildKeyframeStack(List<Pair<String, JsonElement>> entries, boolean isForRotation) throws MolangException {
        if (entries.isEmpty()) {
            return new AzKeyframeStack<AzKeyframe<IValue>>();
        }
        ObjectArrayList xFrames = new ObjectArrayList();
        ObjectArrayList yFrames = new ObjectArrayList();
        ObjectArrayList zFrames = new ObjectArrayList();
        MolangValue xPrev = null;
        MolangValue yPrev = null;
        MolangValue zPrev = null;
        Pair<String, JsonElement> prevEntry = null;
        for (Pair<String, JsonElement> entry : entries) {
            JsonObject obj;
            JsonArray array;
            String key = (String)entry.getFirst();
            JsonElement element = (JsonElement)entry.getSecond();
            if (key.equals("easing") || key.equals("easingArgs") || key.equals("lerp_mode")) continue;
            double prevTime = prevEntry != null ? Double.parseDouble((String)prevEntry.getFirst()) : 0.0;
            double curTime = NumberUtils.isCreatable((String)key) ? Double.parseDouble((String)entry.getFirst()) : 0.0;
            double timeDelta = curTime - prevTime;
            JsonArray keyframeVector = element instanceof JsonArray ? (array = (JsonArray)element) : GsonHelper.getAsJsonArray((JsonObject)element.getAsJsonObject(), (String)"vector");
            MolangValue rawXValue = MolangParser.parseJson(keyframeVector.get(0));
            MolangValue rawYValue = MolangParser.parseJson(keyframeVector.get(1));
            MolangValue rawZValue = MolangParser.parseJson(keyframeVector.get(2));
            MolangValue xValue = isForRotation && rawXValue.isConstant() ? new Constant(Math.toRadians(-rawXValue.get())) : rawXValue;
            MolangValue yValue = isForRotation && rawYValue.isConstant() ? new Constant(Math.toRadians(-rawYValue.get())) : rawYValue;
            MolangValue zValue = isForRotation && rawZValue.isConstant() ? new Constant(Math.toRadians(rawZValue.get())) : rawZValue;
            JsonObject entryObj = element instanceof JsonObject ? (obj = (JsonObject)element) : null;
            AzEasingType easingType = entryObj != null && entryObj.has("easing") ? AzEasingTypeLoader.fromJson(entryObj.get("easing")) : AzEasingTypes.LINEAR;
            ObjectArrayList easingArgs = entryObj != null && entryObj.has("easingArgs") ? JsonUtil.jsonArrayToList(GsonHelper.getAsJsonArray((JsonObject)entryObj, (String)"easingArgs"), ele -> new Constant(ele.getAsDouble())) : new ObjectArrayList();
            xFrames.add(new AzKeyframe<MolangValue>(timeDelta * 20.0, prevEntry == null ? xValue : xPrev, xValue, easingType, (List<MolangValue>)easingArgs));
            yFrames.add(new AzKeyframe<MolangValue>(timeDelta * 20.0, prevEntry == null ? yValue : yPrev, yValue, easingType, (List<MolangValue>)easingArgs));
            zFrames.add(new AzKeyframe<MolangValue>(timeDelta * 20.0, prevEntry == null ? zValue : zPrev, zValue, easingType, (List<MolangValue>)easingArgs));
            xPrev = xValue;
            yPrev = yValue;
            zPrev = zValue;
            prevEntry = entry;
        }
        return new AzKeyframeStack<AzKeyframe<IValue>>((List<AzKeyframe<IValue>>)xFrames, (List<AzKeyframe<IValue>>)yFrames, (List<AzKeyframe<IValue>>)zFrames);
    }

    private static double readTimestamp(String timestamp) {
        return NumberUtils.isCreatable((String)timestamp) ? Double.parseDouble(timestamp) : 0.0;
    }
}

