/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

@Deprecated
public class PiglinSpecificSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEARBY_ADULT_PIGLINS});

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.PIGLIN_SPECIFIC.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        ObjectArrayList adultPiglins = new ObjectArrayList();
        BrainUtils.withMemory(brain, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, entities -> {
            Mob nemesis = null;
            Hoglin nearestHuntableHoglin = null;
            Hoglin nearestBabyHoglin = null;
            LivingEntity nearestZombified = null;
            Player nearestPlayerWithoutGold = null;
            Player nearestPlayerWithWantedItem = null;
            ObjectArrayList visibleAdultPiglins = new ObjectArrayList();
            int adultHoglinCount = 0;
            for (LivingEntity target : entities.findAll(obj -> true)) {
                if (target instanceof Hoglin) {
                    Hoglin hoglin = (Hoglin)target;
                    if (hoglin.isBaby() && nearestBabyHoglin == null) {
                        nearestBabyHoglin = hoglin;
                        continue;
                    }
                    if (!hoglin.isAdult()) continue;
                    ++adultHoglinCount;
                    if (nearestHuntableHoglin != null || !hoglin.canBeHunted()) continue;
                    nearestHuntableHoglin = hoglin;
                    continue;
                }
                if (target instanceof PiglinBrute) {
                    PiglinBrute brute = (PiglinBrute)target;
                    visibleAdultPiglins.add(brute);
                    continue;
                }
                if (target instanceof Piglin) {
                    Piglin piglin = (Piglin)target;
                    if (!piglin.isAdult()) continue;
                    visibleAdultPiglins.add(piglin);
                    continue;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (nearestPlayerWithoutGold == null && !PiglinAi.isWearingGold((LivingEntity)player) && entity.canAttack((LivingEntity)player)) {
                        nearestPlayerWithoutGold = player;
                    }
                    if (nearestPlayerWithWantedItem != null || player.isSpectator() || !PiglinAi.isPlayerHoldingLovedItem((LivingEntity)player)) continue;
                    nearestPlayerWithWantedItem = player;
                    continue;
                }
                if (nemesis != null || !(target instanceof WitherSkeleton) && !(target instanceof WitherBoss)) {
                    if (nearestZombified != null || !PiglinAi.isZombified((EntityType)target.getType())) continue;
                    nearestZombified = target;
                    continue;
                }
                nemesis = (Mob)target;
            }
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, nemesis);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_HUNTABLE_HOGLIN, nearestHuntableHoglin);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, nearestBabyHoglin);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, nearestZombified);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD, nearestPlayerWithoutGold);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, nearestPlayerWithWantedItem);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS, visibleAdultPiglins);
            BrainUtils.setMemory(brain, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, Integer.valueOf(visibleAdultPiglins.size()));
            BrainUtils.setMemory(brain, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, Integer.valueOf(adultHoglinCount));
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_REPELLENT, (BlockPos)BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)8, (int)4, pos -> {
                BlockState state = level.getBlockState(pos);
                boolean isRepellent = state.is(BlockTags.PIGLIN_REPELLENTS);
                return isRepellent && state.is(Blocks.SOUL_CAMPFIRE) ? CampfireBlock.isLitCampfire((BlockState)state) : isRepellent;
            }).orElse(null));
        });
        BrainUtils.withMemory(brain, MemoryModuleType.NEAREST_LIVING_ENTITIES, arg_0 -> PiglinSpecificSensor.lambda$doTick$3((List)adultPiglins, arg_0));
        BrainUtils.setMemory(brain, MemoryModuleType.NEARBY_ADULT_PIGLINS, adultPiglins);
    }

    private static /* synthetic */ void lambda$doTick$3(List adultPiglins, List entities) {
        for (LivingEntity target : entities) {
            AbstractPiglin piglin;
            if (!(target instanceof AbstractPiglin) || !(piglin = (AbstractPiglin)target).isAdult()) continue;
            adultPiglins.add(piglin);
        }
    }
}

