/*
 * Decompiled with CFR 0.152.
 */
package com.betterinvisibility;

import com.betterinvisibility.BetterInvisibilityConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

@EventBusSubscriber(modid="betterinvisibility", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class InvisibleHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void turnMobsInvisible(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player entityplayer = (Player)entity;
            if (entityplayer != Minecraft.getInstance().player && !BetterInvisibilityConfig.showArmorWeapons && (entityplayer.isInvisibleTo((Player)Minecraft.getInstance().player) || entityplayer.isInvisible())) {
                event.setCanceled(true);
            }
        } else if (!BetterInvisibilityConfig.showMobArmorWeapons && entity.isInvisible()) {
            event.setCanceled(true);
        }
        if (entity.hasEffect(MobEffects.INVISIBILITY)) {
            MobEffectInstance invisiCheck = entity.getEffect(MobEffects.INVISIBILITY);
            if (invisiCheck.getDuration() == 0) {
                entity.removeEffect(MobEffects.INVISIBILITY);
                event.getPoseStack().clear();
            } else {
                event.getPoseStack().clear();
                if (!event.isCanceled() && !BetterInvisibilityConfig.showArmorWeapons) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

