/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.caelus;

import com.illusivesoulworks.caelus.api.CaelusApi;
import com.illusivesoulworks.caelus.common.CaelusApiImpl;
import com.illusivesoulworks.caelus.common.CaelusEvents;
import com.illusivesoulworks.caelus.common.network.CPacketFlight;
import com.illusivesoulworks.caelus.common.network.CaelusServerPayloadHandler;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="caelus")
public class CaelusNeoForgeMod {
    public CaelusNeoForgeMod(IEventBus eventBus) {
        CaelusApiImpl.setup();
        eventBus.addListener(this::registerPayloadHandler);
        eventBus.addListener(this::attributeSetup);
        NeoForge.EVENT_BUS.addListener(this::entityTick);
    }

    private void attributeSetup(EntityAttributeModificationEvent evt) {
        for (EntityType type : evt.getTypes()) {
            evt.add(type, CaelusApi.getInstance().getFallFlyingAttribute());
        }
    }

    private void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        evt.registrar("caelus").playToServer(CPacketFlight.TYPE, StreamCodec.unit((Object)CPacketFlight.INSTANCE), CaelusServerPayloadHandler.getInstance()::handleFlight);
    }

    private void entityTick(EntityTickEvent.Post evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CaelusEvents.livingTick(livingEntity);
        }
    }
}

