/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.items.armor;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.init.ModKeybind;
import com.github.L_Ender.cataclysm.items.KeybindUsingArmor;
import com.github.L_Ender.cataclysm.message.MessageArmorKey;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.items.armor.CSArmorMaterialRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.items.armor.ImbuableCSArmorItem;
import net.acetheeldritchking.cataclysm_spellbooks.registries.ItemRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class CursiumMageArmorItem
extends ImbuableCSArmorItem
implements KeybindUsingArmor {
    public CursiumMageArmorItem(ArmorItem.Type slot, Item.Properties settings) {
        super((Holder<ArmorMaterial>)CSArmorMaterialRegistry.CURSIUM_WARLOCK_ARMOR, slot, settings, CursiumMageArmorItem.schoolAttributesWithResistance((Holder<Attribute>)AttributeRegistry.ICE_SPELL_POWER, (Holder<Attribute>)AttributeRegistry.ICE_MAGIC_RESIST, 150, 0.2f, 0.05f, 0.1f));
    }

    public void setDamage(ItemStack stack, int damage) {
        if (CMConfig.Armor_Infinity_Durability) {
            super.setDamage(stack, 0);
        } else {
            super.setDamage(stack, damage);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.type == ArmorItem.Type.HELMET) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_helmet.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_helmet.desc2", (Object[])new Object[]{ModKeybind.HELMET_KEY_ABILITY.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.type == ArmorItem.Type.CHESTPLATE) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc2").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_chestplate.desc3").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm_spellbooks.cursium_chestplate.desc4").withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.type == ArmorItem.Type.LEGGINGS) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_leggings.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_leggings.desc2").withStyle(ChatFormatting.DARK_GREEN));
        }
        if (this.type == ArmorItem.Type.BOOTS) {
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_boots.desc").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursium_boots.desc2", (Object[])new Object[]{ModKeybind.BOOTS_KEY_ABILITY.getTranslatedKeyMessage()}).withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    @Override
    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (player.getItemBySlot(EquipmentSlot.HEAD).getItem() == ItemRegistries.CURSIUM_MAGE_HELMET.get() && pLevel.isClientSide() && ModKeybind.HELMET_KEY_ABILITY.isDown()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageArmorKey(EquipmentSlot.HEAD.ordinal(), player.getId(), 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onKeyPacket(player, pStack, 5);
            }
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() == ItemRegistries.CURSIUM_MAGE_BOOTS.get() && pLevel.isClientSide() && ModKeybind.BOOTS_KEY_ABILITY.isDown()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageArmorKey(EquipmentSlot.HEAD.ordinal(), player.getId(), 7), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onKeyPacket(player, pStack, 7);
            }
        }
    }

    public void onKeyPacket(Player player, ItemStack itemStack, int i) {
        if (i == 5 && player != null && !player.getCooldowns().isOnCooldown((Item)ItemRegistries.CURSIUM_MAGE_HELMET.get())) {
            boolean flag = false;
            List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate(24.0));
            for (Entity entities : list) {
                if (!(entities instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entities;
                flag = true;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 160));
            }
            if (flag) {
                player.getCooldowns().addCooldown((Item)ItemRegistries.CURSIUM_MAGE_HELMET.get(), 200);
            }
        }
        if (i == 7 && player != null && !player.getCooldowns().isOnCooldown((Item)ItemRegistries.CURSIUM_MAGE_BOOTS.get())) {
            float speed = -1.8f;
            float yaw = (float)Math.toRadians(player.getYRot() + 90.0f);
            Vec3 vec3 = player.getDeltaMovement().add((double)speed * Math.cos(yaw), 0.0, (double)speed * Math.sin(yaw));
            player.setDeltaMovement(vec3.x, 0.4, vec3.z);
            player.getCooldowns().addCooldown((Item)ItemRegistries.CURSIUM_MAGE_BOOTS.get(), 200);
        }
    }
}

