/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.BeaverEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.BestiaryModel;
import net.emilsg.clutterbestiary.entity.custom.BeaverEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class BeaverModel<T extends BeaverEntity>
extends BestiaryModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart head;

    public BeaverModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.head = this.all.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)4.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, -10.0f, 8.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontRightLeg = all.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(0, 31).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)5.0f, (float)-8.0f));
        PartDefinition backRightLeg = all.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(28, 4).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightFlipper = backRightLeg.addOrReplaceChild("rightFlipper", CubeListBuilder.create().texOffs(14, 19).addBox(-1.5f, -0.125f, -2.5f, 3.0f, 0.25f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)1.865f, (float)-0.5f));
        PartDefinition backLeftLeg = all.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(0, 24).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftFlipper = backLeftLeg.addOrReplaceChild("leftFlipper", CubeListBuilder.create().texOffs(10, 19).addBox(-1.5f, -0.125f, -2.5f, 3.0f, 0.25f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)1.865f, (float)-0.5f));
        PartDefinition frontLeftLeg = all.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(0, 19).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)5.0f, (float)-8.0f));
        PartDefinition tail = all.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 19).addBox(-4.0f, 0.0f, 1.0f, 8.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(28, 0).addBox(-3.0f, 0.0f, -1.0f, 6.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition head = all.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, 2.0f, -5.75f, 2.0f, 1.0f, 0.25f, new CubeDeformation(0.0f)).texOffs(26, 19).addBox(-3.0f, -2.0f, -5.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-2.0f, 0.0f, -6.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-10.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.5f;
            this.head.offsetScale(this.createVec3f(babyScale));
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 1.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.head.offsetScale(this.createVec3f(0.9f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(BeaverEntity beaverEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles((LivingEntity)beaverEntity, netHeadYaw, headPitch, ageInTicks);
        boolean isTouchingWater = beaverEntity.isInWater();
        if (!isTouchingWater) {
            this.animateWalk(BeaverEntityAnimations.BEAVER_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            this.animate(beaverEntity.idleAnimationState, BeaverEntityAnimations.BEAVER_IDLE, ageInTicks, 1.0f);
        } else {
            float animationSpeed = (float)(beaverEntity.getDeltaMovement().length() * 5.0) + Math.abs(0.5f);
            if (animationSpeed >= 1.2f) {
                animationSpeed = 1.2f;
            }
            this.animate(beaverEntity.waterAnimationState, BeaverEntityAnimations.BEAVER_SWIM, ageInTicks, animationSpeed);
        }
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

