/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.KoiAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.ParentFishModel;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class KoiModel<T extends KoiEntity>
extends ParentFishModel<T> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart bodyPatternLayer;
    private final ModelPart head;
    private final ModelPart headPatternLayer;

    public KoiModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.bodyPatternLayer = this.body.getChild("bodyPatternLayer");
        this.head = this.body.getChild("head");
        this.headPatternLayer = this.head.getChild("headPatternLayer");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)-5.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -1.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyPatternLayer = body.addOrReplaceChild("bodyPatternLayer", CubeListBuilder.create().texOffs(0, 13).addBox(-2.0f, -4.0f, -1.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodySecondaryPatternLayer = body.addOrReplaceChild("bodySecondaryPatternLayer", CubeListBuilder.create().texOffs(0, 40).addBox(-2.0f, -4.0f, -1.0f, 4.0f, 4.0f, 9.0f, new CubeDeformation(0.02f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition backFin = body.addOrReplaceChild("backFin", CubeListBuilder.create().texOffs(26, -1).addBox(0.0f, -2.0f, -3.5f, 0.0f, 2.0f, 7.0f, new CubeDeformation(0.001f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)3.5f));
        PartDefinition frontLeftFin = body.addOrReplaceChild("frontLeftFin", CubeListBuilder.create().texOffs(28, 16).addBox(0.0f, 0.0f, -1.5f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.5f));
        PartDefinition frontRightFin = body.addOrReplaceChild("frontRightFin", CubeListBuilder.create().texOffs(23, 16).addBox(-2.0f, 0.0f, -1.5f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.5f));
        PartDefinition backLeftFin = body.addOrReplaceChild("backLeftFin", CubeListBuilder.create().texOffs(31, 20).addBox(0.0f, 0.0f, -1.5f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.offset((float)2.0f, (float)0.0f, (float)5.5f));
        PartDefinition backRightFin = body.addOrReplaceChild("backRightFin", CubeListBuilder.create().texOffs(24, 20).addBox(-3.0f, 0.0f, -1.5f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)5.5f));
        PartDefinition tailFin = body.addOrReplaceChild("tailFin", CubeListBuilder.create().texOffs(0, 26).addBox(0.0f, -4.0f, 0.0f, 0.0f, 8.0f, 6.0f, new CubeDeformation(0.001f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)8.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 9).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-1.0f));
        PartDefinition headPatternLayer = head.addOrReplaceChild("headPatternLayer", CubeListBuilder.create().texOffs(12, 26).addBox(-1.5f, -1.5f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWhisker = head.addOrReplaceChild("leftWhisker", CubeListBuilder.create().texOffs(27, 23).addBox(0.0f, 0.0f, -0.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offset((float)1.5f, (float)1.5f, (float)-1.5f));
        PartDefinition rightWhisker = head.addOrReplaceChild("rightWhisker", CubeListBuilder.create().texOffs(30, 23).addBox(0.0f, 1.0f, 1.5f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offset((float)-1.5f, (float)0.5f, (float)-3.5f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    @Override
    public void setAngles(KoiEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updatePatternVisibility(entity.getPrimaryPatternTypeVariant() != KoiPrimaryPatternTypeVariant.NONE);
        this.animate(entity.swimmingAnimationState, KoiAnimations.KOI_SWIM, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        float babyScale = 0.35f;
        matrices.pushPose();
        if (this.young) {
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 2.65, 0.0);
        }
        this.root().render(matrices, vertexConsumer, light, overlay, color);
        matrices.popPose();
    }

    private void updatePatternVisibility(boolean patternVisibility) {
        this.bodyPatternLayer.visible = patternVisibility;
    }

    @Override
    protected ModelPart getHeadPart() {
        return null;
    }

    public ModelPart root() {
        return this.root;
    }
}

