/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.ChameleonModel;
import net.emilsg.clutterbestiary.entity.custom.ChameleonEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class ChameleonColorFeatureRenderer
extends RenderLayer<ChameleonEntity, ChameleonModel<ChameleonEntity>> {
    private final ChameleonModel<ChameleonEntity> layerModel;

    public ChameleonColorFeatureRenderer(RenderLayerParent<ChameleonEntity, ChameleonModel<ChameleonEntity>> ctx, EntityModelSet loader) {
        super(ctx);
        this.layerModel = new ChameleonModel(loader.bakeLayer(ModModelLayers.CHAMELEON));
    }

    private static int getColor(ChameleonEntity chameleonEntity) {
        if (chameleonEntity.isDeadOrDying()) {
            return 0xFF7070;
        }
        Level world = chameleonEntity.level();
        BlockPos entityPos = chameleonEntity.blockPosition();
        BlockState blockState = world.getBlockState(entityPos);
        BlockPos blockColorPos = entityPos;
        if (blockState.isAir() || blockState.getBlock() instanceof FlowerBlock) {
            BlockPos belowPos = entityPos.below();
            BlockState belowState = world.getBlockState(belowPos);
            if (belowState.isAir()) {
                return chameleonEntity.getTargetColor();
            }
            blockState = belowState;
            blockColorPos = belowPos;
        }
        BlockColors blockColorProvider = Minecraft.getInstance().getBlockColors();
        int color = -1;
        if (blockColorProvider != null) {
            color = blockColorProvider.getColor(blockState, (BlockAndTintGetter)world, blockColorPos, 1);
        }
        if (color == -1 || color == 0) {
            MapColor mapColor = blockState.getMapColor((BlockGetter)world, blockColorPos);
            color = mapColor != null && mapColor.col != 0 ? mapColor.col : 9487484;
        }
        return color;
    }

    public void render(PoseStack matrices, MultiBufferSource providers, int light, ChameleonEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        int rgb = ChameleonColorFeatureRenderer.getColor(entity);
        int argb = 0xFF000000 | rgb & 0xFFFFFF;
        ResourceLocation texture = this.getTextureLocation((Entity)entity);
        if (entity.isInvisible()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.shouldEntityAppearGlowing((Entity)entity)) {
                ((ChameleonModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.layerModel);
                this.layerModel.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
                this.layerModel.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                VertexConsumer vc = providers.getBuffer(RenderType.outline((ResourceLocation)texture));
                this.layerModel.renderToBuffer(matrices, vc, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), -16777216);
            }
            return;
        }
        ChameleonColorFeatureRenderer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.layerModel, (ResourceLocation)texture, (PoseStack)matrices, (MultiBufferSource)providers, (int)light, (LivingEntity)entity, (float)limbAngle, (float)limbDistance, (float)animationProgress, (float)headYaw, (float)headPitch, (float)tickDelta, (int)argb);
    }
}

