/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ButterflyDupeSporeBlossomGoal
extends MoveToBlockGoal {
    ButterflyEntity butterflyEntity;
    int dupeCooldown;

    public ButterflyDupeSporeBlossomGoal(ButterflyEntity butterflyEntity, double speed, int dupeCooldown) {
        super((PathfinderMob)butterflyEntity, speed, 12);
        this.butterflyEntity = butterflyEntity;
        this.dupeCooldown = dupeCooldown;
    }

    public boolean canUse() {
        return this.butterflyEntity.getDupeTimer() >= this.dupeCooldown && super.canUse();
    }

    public double acceptedDistance() {
        return 1.5;
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.butterflyEntity.getDupeTimer() >= this.dupeCooldown;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            if (!this.butterflyEntity.level().isClientSide) {
                this.butterflyEntity.setDupeTimer(0);
                this.butterflyEntity.spawnAtLocation(new ItemStack((ItemLike)Items.SPORE_BLOSSOM));
            }
            this.stop();
        }
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.is(Blocks.SPORE_BLOSSOM);
    }
}

