/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class HoverGoal
extends Goal {
    private final ParentAnimalEntity animalEntity;
    private int hoverTime;

    public HoverGoal(ParentAnimalEntity animalEntity) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.animalEntity = animalEntity;
    }

    public boolean canUse() {
        return this.animalEntity.getNavigation().isDone() && this.animalEntity.getRandom().nextInt(24) == 0;
    }

    public boolean canContinueToUse() {
        return this.hoverTime-- > 0;
    }

    public void start() {
        this.hoverTime = this.animalEntity.getRandom().nextInt(40);
    }

    public void tick() {
        if (this.animalEntity.isInWater()) {
            this.stop();
        }
        this.animalEntity.getNavigation().stop();
        double hoverY = Math.sin((double)this.animalEntity.tickCount * 0.2) * 0.02;
        this.animalEntity.setDeltaMovement(0.0, hoverY, 0.0);
    }
}

